% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11_read_proteingroups.R
\name{demultiplex}
\alias{demultiplex}
\title{Demultiplex snames}
\usage{
demultiplex(x, verbose = FALSE)
}
\arguments{
\item{x}{character vector}

\item{verbose}{TRUE or FALSE}
}
\value{
character
}
\description{
Demultiplex maxquant samplenames
}
\details{
\verb{WT(L).KD(H).R1\{H/L\}  -> KD_WT.R1}
\verb{WT(1).KD(2).R1\{1\}    -> WT.R1}
\code{         WT.R1       -> WT.R1}
}
\examples{
# uniplexed / intensity / ratio
   demultiplex(c('KD.R1','OE.R1'))
   demultiplex(c('WT(L).KD(M).OE(H).R1{M}',  'WT(L).KD(M).OE(H).R1{H}'))
   demultiplex(c('WT(L).KD(M).OE(H).R1{M/L}','WT(L).KD(M).OE(H).R1{H/L}'))
# run / replicate
   demultiplex(c('WT(L).OE(H).R1{L}',    'WT(L).OE(H).R1{H}'))     # run
   demultiplex(c('WT.R1(L).OE.R1(H){L}', 'WT.R1(L).OE.R1(H){H}'))  # repl
# label / index
   demultiplex(c('WT(L).OE(H).R1{L}',    'WT(L).OE(H).R1{H}'))     # label
   demultiplex(c('WT(1).OE(2).R1{1}',    'WT(1).OE(2).R1{2}'))     # index
# with unused channels
   demultiplex('WT(1).KD(2).OE(3).R1{6}')
}
