% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{rmskatenaparser}
\alias{rmskatenaparser}
\title{atena annotation parser of RepeatMasker annotations}
\usage{
rmskatenaparser(gr, strict = FALSE, insert = 1000)
}
\arguments{
\item{gr}{A [`GRanges`][GenomicRanges::GRanges-class] object with
RepeatMasker annotations from \link[AnnotationHub]{AnnotationHub}}

\item{strict}{(Default FALSE) A logical; if TRUE, the 80-80 rule is applied,
i.e. only copies with more than 80% identity to the reference
and more than 80 bp long are reported.}

\item{insert}{(Default 1000L) An integer > 0. Fragments are assembled 
together if the distance between their closest extremities
is equal or less than \code{insert}. When \code{insert} = 0, two fragments
are assembled if they are in contact next to each other.}
}
\value{
A [`GRangesList`][GenomicRanges::GRangesList-class] object.
}
\description{
atena annotation parser of RepeatMasker annotations
}
\details{
atena annotation parser of RepeatMasker annotations.
Parses RepeatMasker annotations from UCSC by assembling together fragments
from the same transposable element (TE) that are close enough (determined
by the \code{insert} parameter). For TEs from the LTR class, the parser
tries to reconstruct full-length, when possible, or partial TEs following
the LTR - internal region - LTR structure. Equivalences between LTR and
internal regions are found by, first, identifying LTR regions (those with
the "LTR" substring in their name) and internal regions (those with a
suffix such as "-int", "-I", etc.). Then, LTR are assigned to internal
regions for which the comparison of the two names are has a higher number
of equal consecutive characters.
}
\examples{
rmskat <- annotaTEs(genome="dm6", parsefun=rmskatenaparser,
                    strict=FALSE)
rmskat

}
