% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/atenaMethod.R
\docType{class}
\name{atenaParam-class}
\alias{atenaParam-class}
\alias{atenaParam}
\alias{show,atenaParam-method}
\title{atena parameter class}
\usage{
atenaParam(
  bfl,
  teFeatures,
  aggregateby = character(0),
  ovMode = "ovUnion",
  geneFeatures = NULL,
  singleEnd = TRUE,
  strandMode = 1L,
  ignoreStrand = FALSE,
  fragments = TRUE,
  pi_prior = 0L,
  theta_prior = 0L,
  em_epsilon = 1e-07,
  maxIter = 100L,
  reassign_mode = "exclude",
  conf_prob = 0.9,
  verbose = TRUE
)

\S4method{show}{atenaParam}(object)
}
\arguments{
\item{bfl}{A \code{BamFile} or \code{BamFileList} object, or a character
string vector of BAM filenames.}

\item{teFeatures}{A \code{GRanges} or \code{GRangesList} object. Elements
in this object should have names, which are used as a grouping factor for
genomic ranges forming a common locus. This grouping is performed previous
to TE expression quantification, unlike the aggregation of quantifications 
performed when the \code{aggregateby} parameter is specified, which is 
performed after individual TE instances are quantified.}

\item{aggregateby}{Character vector with column names from the annotation
to be used to aggregate quantifications. By default, this is an empty
vector, which means that the names of the input \code{GRanges} or
\code{GRangesList} object given in the \code{teFeatures} parameter are used
to aggregate quantifications.}

\item{ovMode}{Character vector indicating the overlapping mode. Available
options are: "ovUnion" (default) and "ovIntersectionStrict",
which implement the corresponding methods from HTSeq
(\url{https://htseq.readthedocs.io/en/release_0.11.1/count.html}).
Ambiguous alignments (alignments overlapping > 1 feature) are not counted.}

\item{geneFeatures}{(Default NULL) A \code{GRanges} or 
\code{GRangesList} object with the
gene annotated features to be quantified. Unique reads are first tallied
with respect to these gene features whereas multi-mapping reads are
preferentially assigned to TEs. Elements should have names indicating the
gene name/id. In case that \code{geneFeatures} is a \code{GRanges} and
contains a metadata column
named \code{type}, only the elements with \code{type} = \code{exon} are 
considered for the analysis. Then, exon counts are summarized to the gene
level. If NULL, gene expression is not quantified.}

\item{singleEnd}{(Default TRUE) Logical value indicating if reads are single
(\code{TRUE}) or paired-end (\code{FALSE}).}

\item{strandMode}{(Default 1) Numeric vector which can take values 0, 1 or
2.
The strand mode is a per-object switch on
\code{\link[GenomicAlignments:GAlignmentPairs-class]{GAlignmentPairs}}
objects that controls the behavior of the strand getter. See
\code{\link[GenomicAlignments:GAlignmentPairs-class]{GAlignmentPairs}}
class for further detail. If \code{singleEnd = TRUE}, then \code{strandMode}
is ignored.}

\item{ignoreStrand}{(Default FALSE) A logical which defines if the strand
should be taken into consideration when computing the overlap between reads
and annotated features. When \code{ignoreStrand = FALSE}, an aligned read
is considered to be overlapping an annotated feature as long as they
have a non-empty intersecting genomic range on the same strand, while when
\code{ignoreStrand = TRUE} the strand is not considered.}

\item{fragments}{(Default TRUE) A logical; applied to paired-end data only.
When \code{fragments=FALSE}, the read-counting method only counts
‘mated pairs’ from opposite strands (non-ambiguous properly paired reads), 
while when \code{fragments=TRUE} same-strand pairs, singletons, reads with 
unmapped pairs and other ambiguous or not properly paired fragments
are also counted (see "Pairing criteria" in 
\code{\link[GenomicAlignments]{readGAlignments}()}). 
For further details see
\code{\link[GenomicAlignments]{summarizeOverlaps}()}.}

\item{pi_prior}{(Default 0) A positive numeric object indicating the prior
on pi. The same prior can be specified for all features setting
\code{pi_prior} as a scalar, or each feature can have a specific prior by
setting \code{pi_prior} as a vector with \code{names()} corresponding to
all feature names. Setting a pi prior is equivalent to adding n unique
reads.}

\item{theta_prior}{(Default 0) A positive numeric object indicating the
prior on Q. The same prior can be specified for all features setting
\code{theta_prior} as a scalar, or each feature can have a specific prior by
setting \code{theta_prior} as a vector with \code{names()} corresponding to
all feature names. Equivalent to adding n non-unique reads.}

\item{em_epsilon}{(Default 1e-7) A numeric scalar indicating the EM
Algorithm Epsilon cutoff.}

\item{maxIter}{A positive integer scalar storing the maximum number of
iterations of the EM SQUAREM algorithm (Du and Varadhan, 2020). Default
is 100 and this value is passed to the \code{maxiter} parameter of the
\code{\link[SQUAREM]{squarem}()} function.}

\item{reassign_mode}{(Default 'exclude') Character vector indicating
reassignment mode after EM step. 
Available methods are 'exclude' (reads with more than one best
assignment are excluded from the final counts), 'choose' (when reads have
more than one best assignment, one of them is randomly chosen), 'average'
(the read count is divided evenly among the best assignments) and 'conf'
(only assignments that exceed a certain threshold -defined by 
\code{conf_prob} parameter- are accepted, then the read count is
proportionally divided among the assignments above \code{conf_prob}).}

\item{conf_prob}{(Default 0.9) Minimum probability for high confidence
assignment.}

\item{verbose}{(Default \code{TRUE}) Logical value indicating whether to
report progress.}

\item{object}{A \linkS4class{atenaParam} object.}
}
\value{
A [`atenaParam`] object.
}
\description{
This is a class for storing parameters to quantify TE (and gene) expression
using the atena method. It is a subclass of the [`QuantifyParam`].

Build an object of the class \code{atenaParam}.
}
\details{
This is the constructor function for objects of the class
\code{atenaParam-class}. This type of object is the input to the
function \code{\link{qtex}()} for quantifying expression of transposable
elements, which will call the atena method with this type of object. The
atena method uses a multiple '__no_feature' approach in which as many
'__no_feature' features as different overlapping patterns of multimapping
reads in the overlapping matrix are used to represent alignments mapping
outside annotations.
}
\section{Slots}{

\describe{
\item{\code{singleEnd}}{(Default TRUE) Logical value indicating if reads are single
(\code{TRUE}) or paired-end (\code{FALSE}).}

\item{\code{strandMode}}{(Default 1) Numeric vector which can take values 0, 1 or 2.
The strand mode is a per-object switch on
\code{\link[GenomicAlignments:GAlignmentPairs-class]{GAlignmentPairs}}
objects that controls the behavior of the strand getter. See
\code{\link[GenomicAlignments:GAlignmentPairs-class]{GAlignmentPairs}}
class for further detail. If \code{singleEnd = TRUE}, then \code{strandMode}
is ignored.}

\item{\code{ignoreStrand}}{(Default FALSE) A logical which defines if the strand
should be taken into consideration when computing the overlap between reads
and annotated features. When \code{ignoreStrand = FALSE}, an aligned read
is considered to be overlapping an annotated feature as long as they
have a non-empty intersecting genomic range on the same strand, while when
\code{ignoreStrand = TRUE} the strand is not considered.}

\item{\code{fragments}}{(Default TRUE) A logical; applied to paired-end data only.
When \code{fragments=FALSE}, the read-counting method only counts
‘mated pairs’ from opposite strands (non-ambiguous properly paired reads), 
while when \code{fragments=TRUE} same-strand pairs, singletons, reads with 
unmapped pairs and other ambiguous or not properly paired fragments
are also counted (see "Pairing criteria" in 
\code{\link[GenomicAlignments]{readGAlignments}()}). 
For further details see
\code{\link[GenomicAlignments]{summarizeOverlaps}()}.}

\item{\code{pi_prior}}{(Default 0) A positive numeric object indicating the prior
on pi. The same prior can be specified for all features setting
\code{pi_prior} as a scalar, or each feature can have a specific prior by
setting \code{pi_prior} as a vector with \code{names()} corresponding to
all feature names. Setting a pi prior is equivalent to adding n unique
reads.}

\item{\code{theta_prior}}{(Default 0) A positive numeric object indicating the
prior on Q. The same prior can be specified for all features setting
\code{theta_prior} as a scalar, or each feature can have a specific prior by
setting \code{theta_prior} as a vector with \code{names()} corresponding to
all feature names. Equivalent to adding n non-unique reads.}

\item{\code{em_epsilon}}{(Default 1e-7) A numeric scalar indicating the EM
Algorithm Epsilon cutoff.}

\item{\code{maxIter}}{A positive integer scalar storing the maximum number of
iterations of the EM SQUAREM algorithm (Du and Varadhan, 2020). Default
is 100 and this value is passed to the \code{maxiter} parameter of the
\code{\link[SQUAREM]{squarem}()} function.}

\item{\code{reassign_mode}}{(Default 'exclude') Character vector indicating
reassignment mode after EM step. 
Available methods are 'exclude' (reads with more than one best
assignment are excluded from the final counts), 'choose' (when reads have
more than one best assignment, one of them is randomly chosen), 'average'
(the read count is divided evenly among the best assignments) and 'conf'
(only assignments that exceed a certain threshold -defined by 
\code{conf_prob} parameter- are accepted, then the read count is
proportionally divided among the assignments above \code{conf_prob}).}

\item{\code{conf_prob}}{(Default 0.9) Minimum probability for high confidence
assignment.}
}}

\examples{
bamfiles <- list.files(system.file("extdata", package="atena"),
                       pattern="*.bam", full.names=TRUE)
\dontrun{
## use the following two instructions to fetch annotations, they are here
## commented out to enable running this example quickly when building and
## checking the package
rmskat <- annotaTEs(genome="dm6", parsefun=rmskatenaparser,
                    strict=FALSE, insert=500)
rmskLTR <- getLTRs(rmskat, relLength=0.8,
                   fullLength=TRUE,
                   partial=TRUE,
                   otherLTR=TRUE)
}

## DO NOT TYPE THIS INSTRUCTION, WHICH JUST LOADS A PRE-COMPUTED ANNOTATION
## YOU SHOULD USE THE INSTRUCTIONS ABOVE TO FETCH ANNOTATIONS
rmskLTR <- readRDS(system.file("extdata", "rmskatLTRrlen80flenpartoth.rds",
                               package="atena"))

## build a parameter object for the atena method
atpar <- atenaParam(bfl=bamfiles,
                    teFeatures=rmskLTR,
                    singleEnd=TRUE,
                    ignoreStrand=TRUE)
atpar


}
