% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{rmskbasicparser}
\alias{rmskbasicparser}
\title{Parser of RepeatMasker annotations}
\usage{
rmskbasicparser(gr)
}
\arguments{
\item{gr}{A [`GRanges`][GenomicRanges::GRanges-class] object with
RepeatMasker annotations from \link[AnnotationHub]{AnnotationHub}}
}
\value{
A [`GRanges`][GenomicRanges::GRanges-class] object.
}
\description{
Parser of RepeatMasker annotations
}
\details{
Parses annotations by removing low complexity regions, simple repeats,
satellites, rRNA, scRNA, snRNA, srpRNA and tRNA. Also removes TEs with a
strand different than "+" or "-". Modifies "repFamily" and
"repClass" columns when a "?" is present or when they are defined
as "Unknown" or "Other". Finally, assigns a unique id to each TE instance
by adding the suffix "_dup" plus a number at the end of the "repName".
}
\examples{
rmskba <- annotaTEs(genome="dm6", parsefun=rmskbasicparser)
rmskba

}
