% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{artms_data_ph_keys}
\alias{artms_data_ph_keys}
\title{Keys File Example}
\format{
Tab delimited file with the following columns:
\describe{
\item{Raw.file}{Raw file processed. Each one should be a unique
biological (or technical) replicate}

\item{IsotopeLabelType}{Type of labeling. \code{L} is used for label free
experiments}

\item{Condition}{Label for conditions. VERY IMPORTANT: Only alpha-numeric
characters and \verb{underscore (_)} are allowed}

\item{BioReplicate}{Label for the Biological replicates. VERY IMPORTANT:
Use the same labeling for bioreplicate as the Condition, but adding a
\verb{dash (-)} corresponding to the number of biological replicate.
For example, for \code{Condition} \code{"Cal"}, use \code{Cal-1}, \code{Cal-2}, \code{Cal-3}, etc
for the bioreplicates}

\item{Run}{The MS run number}
}
}
\usage{
artms_data_ph_keys
}
\description{
the \code{artMS} keys file provides the details of the experimental
design for any given proteomics experiment.

This particular example belongs to a PH experiment consisting of two
head and neck cancer cell lines ("Conditions" \code{"Cal33"} and \code{"HSC6"}),
with 2 biological replicates each (in this reduced version)
}
\keyword{datasets}
