% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{artmsIsSpeciesSupported}
\alias{artmsIsSpeciesSupported}
\title{Check if a species is supported and available}
\usage{
artmsIsSpeciesSupported(species, verbose = TRUE)
}
\arguments{
\item{species}{(char) The species name. Species currently supported
as part of artMS:
\itemize{
\item HUMAN
\item MOUSE
}

And the following species can be used as well, but the user needs to
install the corresponding org.db package:
\itemize{
\item ANOPHELES (\code{install.packages(org.Ag.eg.db)})
\item BOVINE (\code{install.packages(org.Bt.eg.db)})
\item WORM (\code{install.packages(org.Ce.eg.db)})
\item CANINE (\code{install.packages(org.Cf.eg.db)})
\item FLY (\code{install.packages(org.Dm.eg.db)})
\item ZEBRAFISH (\code{install.packages(org.Dr.eg.db)})
\item CHICKEN (\code{install.packages(org.Gg.eg.db)})
\item RHESUS (\code{install.packages(org.Mmu.eg.db)})
\item CHIMP (\code{install.packages(org.Pt.eg.db)})
\item RAT (\code{install.packages(org.Rn.eg.db)})
\item YEAST (\code{install.packages(org.Sc.sgd.db)})
\item PIG (\code{install.packages(org.Ss.eg.db)})
\item XENOPUS (\code{install.packages(org.Xl.eg.db)})
}}

\item{verbose}{(logical) \code{TRUE} (default) shows function messages}
}
\value{
(string) Name of the package for the given species
}
\description{
Given a species name, it checkes whether is supported, and
if supported, check whether the annotation package is installed.
}
\examples{
# Should return TRUE
artmsIsSpeciesSupported(species = "HUMAN")
artmsIsSpeciesSupported(species = "CHIMP")
}
\keyword{annotation,}
\keyword{species}
