% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidenceToSaintExpressFormat.R
\name{artmsEvidenceToSaintExpress}
\alias{artmsEvidenceToSaintExpress}
\title{MaxQuant evidence file to SAINTexpress format}
\usage{
artmsEvidenceToSaintExpress(
  evidence_file,
  keys_file,
  ref_proteome_file,
  quant_variable = c("msspc", "msint"),
  output_file,
  verbose = TRUE
)
}
\arguments{
\item{evidence_file}{(char) The evidence file path and name}

\item{keys_file}{(char) Keys file with a SAINT column
specifying test (\code{T}) and control (\code{C}) conditions}

\item{ref_proteome_file}{(char) Reference proteome path file name in
fasta format}

\item{quant_variable}{(char) choose either
\itemize{
\item \code{msspc} (spectral counts, default) or
\item \code{msint} (MS Intensity)
}}

\item{output_file}{(char) Output file name (must have extension .txt)}

\item{verbose}{(logical) \code{TRUE} (default) shows function messages}
}
\value{
The 3 required files by SAINTexpress:
\itemize{
\item \code{interactions.txt}
\item \code{preys.txt}
\item \code{baits.txt}
}
}
\description{
Converts the MaxQuant evidence file to the 3 required files
by SAINTexpress. One can choose to either use the \verb{spectral counts}
(use \code{msspc}) or the \code{intensities} (use \code{msint}) for the analysis.
}
\examples{
# Testing that the files cannot be empty
artmsEvidenceToSaintExpress(evidence_file = NULL, 
keys_file = NULL, ref_proteome_file = NULL)
}
\keyword{APMS}
\keyword{SAINT,}
\keyword{SAINTexpress,}
