% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{upsample_counts}
\alias{upsample_counts}
\title{Upsample a counts table to a higher taxon level}
\usage{
upsample_counts(counts_table, tax_table, higher_level)
}
\arguments{
\item{counts_table}{A organism x sample data frame of counts}

\item{tax_table}{A organism x taxlev data frame of labels}

\item{higher_level}{Higher taxon level to upsample to}
}
\value{
A organism x sample data frame of counts
}
\description{
Upsample a counts table to a higher taxon level
}
\examples{
toy_data <- readRDS(system.file("extdata/toy_data.rds", 
package = "animalcules"))
tax_table <- toy_data$tax_table
sam_table <- toy_data$sam_table
counts_table <- toy_data$counts_table
counts_table <- upsample_counts(counts_table, tax_table, "phylum")

}
