% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relabu_barplot.R
\name{relabu_barplot}
\alias{relabu_barplot}
\title{Plot bar plots of sample and group level relative abundance}
\usage{
relabu_barplot(
  MAE,
  tax_level,
  order_organisms = c(),
  sort_by = c("nosort", "conditions", "organisms", "alphabetically"),
  group_samples = FALSE,
  group_conditions = "ALL",
  sample_conditions = c(),
  isolate_samples = c(),
  discard_samples = c(),
  show_legend = TRUE
)
}
\arguments{
\item{MAE}{A multi-assay experiment object}

\item{tax_level}{The taxon level used for organisms}

\item{order_organisms}{A character list of organisms to send to top}

\item{sort_by}{Sort bars by one of 
c("nosort", "conditions", "organisms", "alphabetically")}

\item{group_samples}{A bool specifying whether to group samples}

\item{group_conditions}{Group by one or more conditions e.g. "ALL" or "SEX"}

\item{sample_conditions}{Plot associatied conditions with samples.}

\item{isolate_samples}{Isolate specific samples e.g. c("SAM_01", "SAM_02")}

\item{discard_samples}{Discard specific samples e.g. c("SAM_01", "SAM_02")}

\item{show_legend}{A bool specifying whether or not to show organisms legend}
}
\value{
A plotly object
}
\description{
Plot bar plots of sample and group level relative abundance
}
\examples{
data_dir <- system.file("extdata/MAE.rds", package = "animalcules")
toy_data <- readRDS(data_dir)
p <- relabu_barplot(toy_data,
  tax_level = "family",
  order_organisms = c("Retroviridae"),
  sort_by = "organisms",
  sample_conditions = c("SEX", "AGE"),
  show_legend = TRUE
)
p

}
