% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_biomarker.R
\name{find_biomarker}
\alias{find_biomarker}
\title{Identify biomarkers}
\usage{
find_biomarker(
  MAE,
  tax_level,
  input_select_target_biomarker,
  nfolds = 3,
  nrepeats = 3,
  seed = 99,
  percent_top_biomarker = 0.2,
  model_name = c("logistic regression", "random forest")
)
}
\arguments{
\item{MAE}{A multi-assay experiment object}

\item{tax_level}{The taxon level used for organisms}

\item{input_select_target_biomarker}{Which condition is the target condition}

\item{nfolds}{number of splits in CV}

\item{nrepeats}{number of CVs with different random splits}

\item{seed}{for repeatable research}

\item{percent_top_biomarker}{Top importance percentage to pick biomarker}

\item{model_name}{one of 'logistic regression', 'random forest'}
}
\value{
A list
}
\description{
Identify biomarkers
}
\examples{
data_dir <- system.file("extdata/MAE.rds", package = "animalcules")
toy_data <- readRDS(data_dir)
p <- find_biomarker(toy_data,
  tax_level = "family",
  input_select_target_biomarker = c("DISEASE"),
  nfolds = 3,
  nrepeats = 3,
  seed = 99,
  percent_top_biomarker = 0.2,
  model_name = "logistic regression"
)
p

}
