% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotAnansi-methods.R
\name{plotAnansi}
\alias{plotAnansi}
\alias{plotAnansi-generic}
\alias{plotAnansi-methods}
\title{Dissociation plot}
\arguments{
\item{x}{a \code{data.frame} object output of \code{\link[=anansi]{anansi()}} in
the table format.}

\item{...}{additional parameters}

\item{layout}{\verb{Character scalar}. Specifies the plot layout to generate. It
must be one of \verb{c("dotplot, graph)}. (Default: \code{dotplot})}

\item{association.type}{\verb{Character scalar}. Specifies the type of
association to show in the plot. One of \code{"disjointed"},
\code{"emergent"} and \code{"full"}. (Default: \code{NULL})}

\item{model.var}{\verb{Character scalar}. Specifies the name of a variable
in the anansi model. It is relevant only when \code{association.type} is
\code{"disjointed"} or \code{"emergent"}. (Default: \code{NULL})}

\item{group}{\verb{Character scalar}. Selects one of the groups included in the
anansi model. It is relevant only when \code{layout} is \code{graph}.
(Default: \code{All})}

\item{signif.threshold}{\verb{Numeric scalar}. Specifies the threshold to
mark the significance of \code{association.type}. (Default: \code{NULL})}

\item{colour_by}{\verb{Character scalar}. Specifies one of the \code{groups}
terms used in the original \code{anansi} call, \code{x} by which points
should be coloured. (Default: \code{NULL})}

\item{color_by}{\verb{Character scalar}. Alias to \code{colour_by}.}

\item{fill_by}{\verb{Character scalar}. Specifies one of the \code{groups}
terms used in the original \code{anansi} call, \code{x} by which points
should be filled (Default: \code{"group"})}

\item{size_by}{\verb{Character scalar}. Specifies one of the \code{groups}
terms used in the original \code{anansi} call, \code{x} by which points
should be sized. (Default: \code{NULL})}

\item{shape_by}{\verb{Character scalar}. Specifies one of the \code{groups}
terms used in the original \code{anansi} call, \code{x} by which points
should be shaped. (Default: \code{NULL})}

\item{x_lab}{\verb{Character scalar}. Specifies the label of the x axis.
(Default: \code{"cor"})}

\item{y_lab}{\verb{Character scalar}. Specifies the label of the y axis.
(Default: \code{""})}

\item{y_position}{\verb{Character scalar}. Specifies the position of the y
labels. It should be either \code{"left"} or \code{"right"}.
(Default: \code{"right"})}

\item{show.cor}{\verb{Logical scalar}. Whether correlation edges should be
labelled with correlation coefficients when \code{layout} is \code{graph}.
(Default: \code{FALSE})}
}
\value{
a figure that can be further modified using the \code{ggplot2} suite

A ggplot2 object.
}
\description{
\code{plotAnansi} generates an association plot from the output of
\code{\link[=anansi]{anansi()}} in the table format. It provides a convenient way to
visually assess relevant results from the anansi analysis, either in the
form of a dotplot or a graph.
}
\details{
\code{plotAnansi} provides a standardised method to visualise the results
of anansi by means of a differential association plot. The input for this
function should be generated from \code{\link[=anansi]{anansi()}} or
\code{\link[=anansi]{anansi()}}, with \code{return.format = "table"}
}
\examples{
# Import libraries
library(mia)
library(TreeSummarizedExperiment)
library(MultiAssayExperiment)
library(ggraph)

web <- randomWeb(n_samples = 100)
mae <- asMAE(web)

# Perform anansi analysis
out <- weaveWeb(mae,
    tableY = "y", tableX = "x"
) |> anansi(formula = ~group_ab)

# Select significant interactions
out <- out[out$full_p.values < 0.05, ]

# Visualise disjointed associations filled by group
plotAnansi(out,
    association.type = "disjointed",
    model.var = "group_ab",
    signif.threshold = 0.05,
    fill_by = "group"
)

# Visualise full associations filled by group
plotAnansi(out,
    association.type = "full",
    signif.threshold = 0.05,
    fill_by = "group"
)

# Visualise full associations as graph
plotAnansi(out,
    layout = "graph",
    association.type = "full",
    signif.threshold = 0.05,
    show.cor = TRUE
)

# Visualise disjointed associations as graph
plotAnansi(out,
    layout = "graph",
    association.type = "disjointed",
    model.var = "group_ab",
    signif.threshold = 0.05
)

}
\seealso{
\code{\link[=anansi]{anansi()}}
}
