% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-coercion.R
\name{anansi-coercion}
\alias{anansi-coercion}
\alias{as.list.anansi::AnansiWeb}
\alias{as.list.anansi::MultiFactor}
\alias{as.data.frame.anansi::AnansiWeb}
\alias{asMAE}
\alias{as.MAE}
\alias{as.MultiAssayExperiment}
\alias{asMultiAssayExperiment}
\alias{asTSE}
\alias{as.TSE}
\alias{as.TreeSummarizedExperiment}
\alias{asTreeSummarizedExperiment}
\title{Coercion functions for anansi}
\usage{
\method{as.list}{`anansi::AnansiWeb`}(x, ...)

\method{as.list}{`anansi::MultiFactor`}(x, ..., use.names = TRUE)

\method{as.data.frame}{`anansi::AnansiWeb`}(x, row.names, optional, ...)

asMAE(x)

asTSE(x)
}
\arguments{
\item{x}{input object}

\item{...}{additional arguments (currently not used).}

\item{use.names}{\verb{Logical scalar}, whether output list should contain
character (Default) or integer data frame. If \code{FALSE}, returns
\code{unfactor(x)}.}

\item{row.names, optional}{Not used. See ?base::data.frame}
}
\value{
An object of the desired class.
}
\description{
Coercion functions for anansi
}
\examples{
# AnansiWeb
x <- randomWeb(
    n_samples = 5,
    n_features_x = 4,
    n_features_y = 6
)

as.list(x)
as.data.frame(x)

# AnansiWeb to MultiAssayExperiment
asMAE(x)
asTSE(x)

# MultiFactor
x <- randomMultiFactor(n_types = 3, n_features = 3)
as.list(x, use.names = TRUE)

}
\seealso{
\code{\link[=unfactor]{unfactor()}}
}
