% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveMultiAssayExperiment.R
\name{saveObject,MultiAssayExperiment-method}
\alias{saveObject,MultiAssayExperiment-method}
\alias{stageObject,MultiAssayExperiment-method}
\title{Save a MultiAssayExperiment}
\usage{
\S4method{saveObject}{MultiAssayExperiment}(x, path, ...)
}
\arguments{
\item{x}{A \linkS4class{MultiAssayExperiment} object or one of its subclasses.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{...}{Additional named arguments to pass to specific methods.}
}
\value{
The contents of \code{x} are saved into a \code{path}, and \code{NULL} is invisibly returned.
}
\description{
Save a \linkS4class{MultiAssayExperiment} to its on-disk representation.
}
\examples{
# Mocking up an MAE
mat <- matrix(rnorm(1000), ncol=10)
colnames(mat) <- letters[1:10]
rownames(mat) <- sprintf("GENE_\%i", seq_len(nrow(mat)))

library(SummarizedExperiment)
se <- SummarizedExperiment(list(counts=mat))

library(MultiAssayExperiment)
mae <- MultiAssayExperiment(list(gene=se))

# Saving it:
tmp <- tempfile()
saveObject(mae, tmp)

}
\author{
Aaron Lun
}
