% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TabixIndexWrapper.R
\docType{class}
\name{TabixIndexWrapper}
\alias{TabixIndexWrapper}
\alias{TabixIndexWrapper-class}
\alias{stageObject,TabixIndexWrapper-method}
\alias{loadTabixIndexWrapper}
\title{Wrapper for a Tabix file}
\usage{
TabixIndexWrapper(path)
}
\arguments{
\item{path}{String containing the path to a Tabix file.}
}
\value{
A TabixIndexWrapper instance that can be used in \code{\link{stageObject}}.
}
\description{
This class is deprecated and only listed here for back-compatibility purposes.
}
\details{
The TabixIndexWrapper class is a subclass of a \linkS4class{Wrapper},
so all of the methods of the latter can also be used here, e.g., \code{path}.
}
\examples{
# Mocking up a Tabix file.
test_tbx <- system.file("extdata", "example.gtf.gz.tbi", package="Rsamtools")

# Creating a TabixIndexWrapper.
wrapped <- TabixIndexWrapper(test_tbx)
wrapped

# Staging the TabixIndexWrapper.
dir <- tempfile()
library(alabaster.base)
info <- stageObject(wrapped, dir, "tab")
invisible(.writeMetadata(info, dir))
list.files(dir, recursive=TRUE)

# Loading it back again:
meta <- acquireMetadata(dir, "tab/file.tbi")
loadObject(meta, dir)

}
\author{
Aaron Lun
}
