% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BigBedFileReference.R
\docType{class}
\name{BigBedFileReference}
\alias{BigBedFileReference}
\alias{BigBedFileReference-class}
\alias{saveObject,BigBedFileReference-method}
\alias{readBigBedFileReference}
\alias{BigBedWrapper}
\alias{BigBedWrapper-class}
\alias{stageObject,BigBedWrapper-method}
\alias{loadBigBedWrapper}
\title{Reference to a bigBed file}
\usage{
BigBedFileReference(path)
}
\arguments{
\item{path}{String containing the path to a bigBed file.}
}
\value{
A BigBedFileReference instance that can be used in \code{\link{stageObject}}.
}
\description{
Reference to a bigBed file, for saving and loading in the \pkg{alabaster} framework.
}
\examples{
# Mocking up a bigBed file.
test_path <- system.file("tests", "test.bb", package = "rtracklayer")

# Creating a BigBedFileReference.
wrapped <- BigBedFileReference(test_path)
wrapped

# Staging the BigBedFileReference.
dir <- tempfile()
saveObject(wrapped, dir)
list.files(dir, recursive=TRUE)

# Loading it back again:
readObject(dir)

}
\author{
Aaron Lun
}
