% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BgzipIndexWrapper.R
\docType{class}
\name{BgzipIndexWrapper}
\alias{BgzipIndexWrapper}
\alias{BgzipIndexWrapper-class}
\alias{stageObject,BgzipIndexWrapper-method}
\alias{loadBgzipIndexWrapper}
\title{Wrapper for a Bgzip index file}
\usage{
BgzipIndexWrapper(path)
}
\arguments{
\item{path}{String containing the path to a Bgzip index file.}
}
\value{
A BgzipIndexWrapper instance that can be used in \code{\link{stageObject}}.
}
\description{
This class is deprecated and only listed here for back-compatibility purposes.
}
\details{
The BgzipIndexWrapper class is a subclass of a \linkS4class{Wrapper},
so all of the methods of the latter can also be used here, e.g., \code{path}.
}
\examples{
# Mocking up a FASTA index file.
input <- system.file("extdata", "ce2dict1.fa", package="Rsamtools")
temp <- tempfile(fileext=".fa.bgz")
copy <- Rsamtools::bgzip(input, dest=temp)
Rsamtools::indexFa(copy)

# Creating a BgzipIndexWrapper.
wrapped <- BgzipIndexWrapper(paste0(copy, ".gzi"))
wrapped

# Staging the BgzipIndexWrapper.
dir <- tempfile()
library(alabaster.base)
info <- stageObject(wrapped, dir, "tab")
invisible(.writeMetadata(info, dir))
list.files(dir, recursive=TRUE)

# Loading it back again:
meta <- acquireMetadata(dir, "tab/file.fa.bgz.gzi")
loadObject(meta, dir)

}
\author{
Aaron Lun
}
