% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BedFileReference.R
\docType{class}
\name{BedFileReference}
\alias{BedFileReference}
\alias{BedFileReference-class}
\alias{saveObject,BedFileReference-method}
\alias{readBedFileReference}
\alias{BedWrapper}
\alias{BedWrapper-class}
\alias{stageObject,BedWrapper-method}
\alias{loadBedWrapper}
\title{Reference to a BED file}
\usage{
BedFileReference(path, index = NULL)
}
\arguments{
\item{path}{String containing the path to a Gzip- or BGZF-compressed BED file.}

\item{index}{String containing a path to a tabix file.
If supplied, \code{path} should be coordinate-sorted and BGZF-compressed.}
}
\value{
A BedFileReference instance that can be used in \code{\link{saveObject}}.
}
\description{
Reference to a BED file, for saving and loading in the \pkg{alabaster} framework.
}
\examples{
# Mocking up a BED file.
raw <- tempfile(fileext=".bed")
bed <- write("chr1\t2222\t33333", file=raw)
tmp <- tempfile(fileext=".bed.bgz")
Rsamtools::bgzip(raw, tmp)

# Creating a BedFileReference.
wrapped <- BedFileReference(tmp)
wrapped

# Extracting the paths:
path(wrapped)
wrapped$index

# Saving it to disk.
dir <- tempfile()
saveObject(wrapped, dir)
list.files(dir, recursive=TRUE)

# Loading it back again:
readObject(dir)

}
\author{
Aaron Lun
}
