% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{featureQC}
\alias{featureQC}
\title{Quality control on features}
\usage{
featureQC(sce, spike, detection_limit = 1, threshold = 0.25, sd = 0.03, pc = 2)
}
\arguments{
\item{sce}{SingleCellExperiment with \code{counts} and \code{ratio}}

\item{spike}{the character name of spike genes. The default is \code{Ercc}}

\item{detection_limit}{Numeric scalar providing the value above which
observations are deemed to be expressed.}

\item{threshold}{A numeric scalar specifying the threshold above which
percentage of cells expressed within each cell type. Default is 0.25}

\item{sd}{A numeric scalar specifying the cell type weighted
allelic ratio mean standard deviation threshold
above which are interested features with highly variation. Default is 0.03}

\item{pc}{pseudocount in the \code{preprocess} step}
}
\value{
A DataFrame of QC statistics includes
\itemize{
  \item{filter_celltype} {indicate whether genes expressed in more than
\code{threshold} cells for all cell types}
  \item{sd} {read counts standard deviation for each feature}
  \item{filter_sd} {indicate whether gene standard deviation
exceed \code{sd}}
  \item{filter_spike} {indicate no spike genes}
  }
}
\description{
Quality control on features
}
\examples{

sce <- makeSimulatedData()
sce <- preprocess(sce)
featureQCmetric <- featureQC(sce)
keep_feature <- (featureQCmetric$filter_celltype &
  featureQCmetric$filter_sd &
  featureQCmetric$filter_spike)
sce <- sce[keep_feature, ]

# or manually setting threshold
featureQCmetric <- featureQC(sce,
  spike = "Ercc",
  threshold = 0.25, sd = 0.03, pc = 2
)
keep_feature <- (featureQCmetric$filter_celltype &
  featureQCmetric$sd > 0.02)
}
