% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{cellQC}
\alias{cellQC}
\title{Quality control on cells}
\usage{
cellQC(
  sce,
  spike,
  threshold = 0,
  mad_sum = 5,
  mad_detected = 3,
  mad_spikegenes = 5
)
}
\arguments{
\item{sce}{SingleCellExperiment with \code{counts} and \code{ratio}}

\item{spike}{the character name of spike genes.
If missing, \code{spikePercent} will all be zero and
\code{filter_spike} will be false.}

\item{threshold}{A numeric scalar specifying the threshold
above which a gene is considered to be detected.}

\item{mad_sum}{A numeric scalar specifying exceed
how many median absolute deviations
from the median log10-counts a cell is considered to be filtered out.
Default is 5.}

\item{mad_detected}{A numeric scalar specifying exceed
how many median absolute deviations
from the median detected features a cell is considered to be filtered out.
Default is 5.}

\item{mad_spikegenes}{A numeric scalar specifying exceed
how many median absolute deviations
from the median spike genes expression percentage a cell
is considered to be filtered out. Default is 5.}
}
\value{
A DataFrame of QC statistics includes
\itemize{
  \item{sum} {the sum of counts of each cell}
  \item{detected} {the number of features above \code{threshold}}
  \item{spikePercent} {the percentage of counts assignes to spike genes}
  \item{filter_sum} {indicate whether log10-counts
   within \code{mad_sum} median absolute deviations
from the median log10-counts for the dataset}
  \item{filter_detected} {indicate whether features detected by this cell
   within \code{mad_detected} median absolute deviations
from the median detected features for the dataset}
  \item{filter_spike} {indicate whether percentage expressed by spike genes
   within \code{mad_spikegenes} median absolute deviations from the median
   spike genes expression percentage for the dataset}
  }
}
\description{
Quality control on cells
}
\examples{
sce <- makeSimulatedData()
sce <- preprocess(sce)
cellQCmetrics <- cellQC(sce)
keep_cell <- (
  cellQCmetrics$filter_sum | # sufficient features (genes)
    # sufficient molecules counted
    cellQCmetrics$filter_detected |
    # sufficient features expressed compared to spike genes
    cellQCmetrics$filter_spike
)
sce <- sce[, keep_cell]

# or manually setting threshold
cellQCmetrics <- cellQC(sce,
  spike = "Ercc",
  mad_detected = 4, mad_spikegenes = 4
)
keep_cell <- (
  cellQCmetrics$sum > 2.4 |
    cellQCmetrics$detected > 110
)
}
