% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitBB.R
\name{allelicRatio}
\alias{allelicRatio}
\title{Fit beta-binomial across cell types}
\usage{
allelicRatio(sce, formula, nogroup = FALSE, level = 0.95, DAItest = FALSE, ...)
}
\arguments{
\item{sce}{A SingleCellExperiment containing assays
(\code{"ratio"}, \code{"counts"}) and colData (\code{"x"},
\code{"part"})}

\item{formula}{The same \code{\link[stats]{formula}} object
used in \code{\link[airpart]{fusedLasso}} or used in \code{\link[splines]{ns}}
when want to detect smooth continuous-axis estimates. eg. formula <- ratio ~ ns(x, df = 5)}

\item{nogroup}{Indicate whether there is previous group step. Default is FALSE represents either
Generalized fused lasso or nonparametric method is used to derive partition. nogroup == TRUE means
the hypothesis that groups of cell types sharing a common regulatory context is not valid}

\item{level}{the level of credible interval (default is 0.95)}

\item{DAItest}{Indicate whether to do Likelihood Ratio test on differential allelic imbalance(DAI)
or equivalent to heterogeneity.}

\item{...}{arguments to pass to \code{\link[apeglm]{apeglm}}
functions}
}
\value{
posterior mean (\code{"ar"}) for allelic ratio
estimate is returned in the rowData for each cell type,
as well as the \code{"s"} value, \code{"fsr"} false sign rate and
credible interval (\code{"lower"} and \code{"upper"}). One can use \code{"fsr"} < 0.005 or
credible intervals contain 0.5 or not for AI test significance. \code{"p.value"} shows DAI test result
and \code{"adj.p.value"} is false discovery rate corrected p values.
}
\description{
This function performs additional inference on the allelic ratio
across cell types, giving posterior mean and credible
intervals per cell type. A Cauchy prior is centered for
each cell type on the allelic ratio from the fused lasso
across all genes in the gene cluster
(or using a weighted means if the fused lasso is not provided).
}
\examples{

sce <- makeSimulatedData()
sce <- preprocess(sce)
sce <- geneCluster(sce, G = seq_len(4))
sce_sub <- wilcoxExt(sce, genecluster = 1)
sce_sub <- allelicRatio(sce_sub, DAItest = TRUE)
}
