% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affystart.R
\name{affystart}
\alias{affystart}
\title{Pre-processing for Affymetrix Data}
\usage{
affystart(
  ...,
  filenames = NULL,
  groups = NULL,
  groupnames = NULL,
  plot = TRUE,
  pca = TRUE,
  squarepca = FALSE,
  plottype = "pdf",
  express = c("rma", "mas5", "gcrma"),
  addname = NULL,
  output = "txt",
  annotate = FALSE,
  ann.vec = c("SYMBOL", "GENENAME", "ENTREZID", "UNIGENE", "REFSEQ")
)
}
\arguments{
\item{\dots}{Requires that all variables be named.}

\item{filenames}{If not all cel files in a directory will be used, pass a
vector of filenames.}

\item{groups}{An integer \code{vector} indicating the group assignments for
the PCA plot.}

\item{groupnames}{A character \code{vector} with group names for PCA legend.}

\item{plot}{Should density and degradation plots be made? Defaults to
\code{TRUE}.}

\item{pca}{Should a PCA plot be made? Defaults to \code{TRUE}.}

\item{squarepca}{Should the y-axis of the PCA plot be made comparable to the
x-axis? This may aid in interpretation of the PCA plot.  Defaults to
\code{FALSE}.}

\item{plottype}{What type of plot to save. Can be "pdf","postscript",
"png","jpeg", or "bmp". Defaults to "pdf". Note that "png" and "jpeg" may
not be available on a given computer. See the help page for
\code{capabilities} and \code{png} for more information.}

\item{express}{One of either rma, mas5, gcrma. Defaults to rma.  Partial
matching OK.}

\item{addname}{Used to append something to the name of the pca plot and the
expression values output file (e.g., if function is run twice using
different methods to compute expression values).}

\item{output}{What format to use for the output of expression values.
Currently only supports text format.}

\item{annotate}{Boolean. Add annotation data to the output file?}

\item{ann.vec}{A character \code{vector} of annotation data to add to the
output file.}
}
\value{
Returns an \code{ExpressionSet}.
}
\description{
This function is designed to automatically read in all cel files in a
directory, make all pre-processing QC plots and compute expression measures.
}
\seealso{
\code{plotHist}, \code{plotDeg}, \code{plotPCA}
}
\author{
James W. MacDonald <jmacdon@u.washington.edu>
}
\keyword{hplot}
\keyword{manip}
