% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakRangeSum.R
\name{peakRangeSum}
\alias{peakRangeSum}
\title{raw eic signal intensity and mass summation and spike removal.}
\usage{
peakRangeSum(peakRange = NULL, spikeScans = 2, rtDevModel = NULL,
gaussAlpha = NULL, 
maxEmptyRt = 7)
}
\arguments{
\item{peakRange}{matrix consisting of 5 columns:
\enumerate{
\item mass-to-charge values
\item intensity
\item retention time (in seconds)
\item scan number
}}

\item{spikeScans}{numeric number of scans <= a spike. 
Any peaks <= this value will be removed (default = 2).= FALSE}

\item{rtDevModel}{loess model to correct retention times.}

\item{gaussAlpha}{numeric alpha value for \code{\link{smth.gaussian}} 
of smoother package. If supplied
gaussian smoothing will be performed (suggested value = 16).}

\item{maxEmptyRt}{numeric maximum size of empty retention time 
beyond which missing values
will be zero-filled}
}
\value{
matrix with masses and intensities summed by 
retention time and retention time
correction based on the loess model supplied, the matrix has spikes
removed (consecutive non-zero intensity values <= spikeScans in length), 
empty time segments are zero filled (> 3 seconds), optionally gaussian 
smoothed using the link{\code{smth.gaussian}} function of the smoother
package 
and is also subset based on the minimum and maximum retention time windows 
supplied (rtWin). 
The returned matrix consists of 5 columns:
\enumerate{
\item average mass-to-charge values by unique retention time
in supplied peakRange table
\item maximum intensity values by unique retention time in supplied
peakRange table
\item loess model corrected retention times
\item original retention time values
\item scan number by unique retention time in supplied peakRange table
}
}
\description{
raw eic signal intensity and mass summation and spike removal.
}
