% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lassoClass.R
\name{lassoClass}
\alias{lassoClass}
\title{Classify using the Lasso}
\usage{
lassoClass(object, groups)
}
\arguments{
\item{object}{object containing the expression measurements; currently the
only method supported is one for ExpressionSet objects}

\item{groups}{character string indicating the column containing the class membership}
}
\value{
object of class \code{glmnet}
}
\description{
Classify using the Lasso
}
\examples{
if (require(ALL)){
  data(ALL, package = "ALL")
  ALL <- addGeneInfo(ALL)
  ALL$BTtype <- as.factor(substr(ALL$BT,0,1))

  resultLasso <- lassoClass(object = ALL, groups = "BTtype")
  plot(resultLasso, label = TRUE,
    main = "Lasso coefficients in relation to degree of
  penalization.")
  topTable(resultLasso, n = 15)
}
}
\references{
Goehlmann, H. and W. Talloen (2009). Gene Expression Studies Using Affymetrix
 Microarrays, Chapman \& Hall/CRC, pp. 183, 205 and 212.
}
\seealso{
\code{\link[glmnet]{glmnet}}
}
\author{
Willem Talloen
}
\keyword{models}
