% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSmoothScat.R
\name{plotComb2Samples}
\alias{plotComb2Samples}
\title{Plots the correlation in gene expression between two samples}
\usage{
plotComb2Samples(
  object,
  x,
  y,
  trsholdX = NULL,
  trsholdY = NULL,
  probe2gene = TRUE,
  ...
)
}
\arguments{
\item{object}{ExpressionSet object for the experiment}

\item{x}{String containing the name of the first sample. This should be a 
the name of a column in the \code{exprs} data of the \code{expressionSet} object.}

\item{y}{String containing the name of the second sample. See \code{x}}

\item{trsholdX}{Vector of two values specifying the X-axis thresholds within which
genes should be highlighted by their gene symbol.}

\item{trsholdY}{Vector of two values specifying the Y-axis thresholds within which
genes should be highlighted by their gene symbol.}

\item{probe2gene}{Boolean indicating whether the probeset should be translated to a gene symbol
(used for the default title of the plot)}

\item{...}{Possibility to add extra plot options. See \code{\link{par}}}
}
\value{
No returned value, a plot is drawn to the current device.
}
\description{
Plots the correlation in gene expression between two samples. Each dot represents
a gene, and the dots have a density-dependent coloring.
Genes with exceptional behavior can be highlighted by showing their gene symbol.
}
\examples{
if (require(ALL)){
  data(ALL, package = "ALL")
  ALL <- addGeneInfo(ALL)
 plotComb2Samples(ALL,"84004", "01003",
    trsholdX = c(10,12), trsholdY = c(4,6),
	   xlab = "a B-cell", ylab = "a T-cell")
}
}
\seealso{
\code{\link{plotCombMultSamples}}
}
\author{
W. Talloen
}
