% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limma.R
\name{limmaTwoLevels}
\alias{limmaTwoLevels}
\title{Wrapper for the limma function for the comparison of two groups 
(two factor levels)}
\usage{
limmaTwoLevels(object, group, probe2gene = TRUE)
}
\arguments{
\item{object}{object of class ExpressionSet}

\item{group}{string indicating the variable defining the two groups
to be compared}

\item{probe2gene}{logical; if \code{TRUE} Affymetrix probeset IDs are translated
into gene symbols; if \code{FALSE} no such translation is done}
}
\value{
S4 object of class 'limma' with the following two components:
\item{MArrayLM}{S4 object of class MArrayLM as returned by the limma
			function of the limma package}
\item{geneSymbols}{character vector of gene symbols; this slot is only
	populated if \code{probe2gene=TRUE} (and if the ExpressionSet object
	is appropriately annotated by \code{addGeneInfo} for gene symbols to
	be extracted)}
}
\description{
Wrapper for the limma function for the comparison of two groups 
(two factor levels)
}
\note{
A 'topTable' method is defined for 'limma' objects.
}
\author{
Tobias Verbeke and Willem Talloen
}
\keyword{models}
