% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence.R
\name{confIntExp}
\alias{confIntExp}
\title{Compute confidence intervals}
\usage{
confIntExp(
  in_ind = 1,
  in_sigLevel = 0.05,
  in_delta = 1,
  in_exposure_vector = NULL,
  in_verbose = FALSE,
  ...
)
}
\arguments{
\item{in_ind}{Index of the input signature to be variated.}

\item{in_sigLevel}{Significance leve (one-sided)}

\item{in_delta}{Inflation parameter for the alternative model.}

\item{in_exposure_vector}{Exposure vector computed for the input sample.}

\item{in_verbose}{Whether to run verbose (TRUE) or not (FALSE)}

\item{...}{Input parameters passed on to \link{variateExpSingle}.}
}
\value{
A list with entries \itemize{ \item \code{upper}: Upper bound of the
  confidence interval \item \code{lower}: Lower bound of the confidence
  interval }
}
\description{
Compute confidence intervals using the (log-)likelihood ratio test, primarily
for one input sample.
}
\examples{
 library(BSgenome.Hsapiens.UCSC.hg19)
 data(lymphoma_test)
 data(lymphoma_cohort_LCD_results)
 data(sigs)
 word_length <- 3
 temp_list <- create_mutation_catalogue_from_df(
   lymphoma_test_df,this_seqnames.field = "CHROM",
   this_start.field = "POS",this_end.field = "POS",
   this_PID.field = "PID",this_subgroup.field = "SUBGROUP",
   this_refGenome = BSgenome.Hsapiens.UCSC.hg19,
   this_wordLength = word_length)
 lymphoma_catalogue_df <- temp_list$matrix
 lymphoma_PIDs <- colnames(lymphoma_catalogue_df)
 data("lymphoma_cohort_LCD_results")
 lymphoma_exposures_df <-
   lymphoma_Nature2013_COSMIC_cutoff_exposures_df[, lymphoma_PIDs]
 lymphoma_sigs <- rownames(lymphoma_exposures_df)
 lymphoma_sig_df <- AlexCosmicValid_sig_df[, lymphoma_sigs]
 confIntExp(in_ind = 1, in_sigLevel = 0.05, in_delta = 0.4,
            in_exposure_vector = lymphoma_exposures_df[, 1],
            in_catalogue_vector = lymphoma_catalogue_df[, 1],
            in_sig_df = lymphoma_sig_df)
            
}
