% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complex_functions.R
\name{aggregate_exposures_by_category}
\alias{aggregate_exposures_by_category}
\title{Aggregate exposures by category}
\usage{
aggregate_exposures_by_category(in_exposures_df, in_sig_ind_df, in_category)
}
\arguments{
\item{in_exposures_df}{Input data frame of exposures.}

\item{in_sig_ind_df}{Input data frame of meta information on the signatures.
Has to match the signatures in \code{in_exposures_df}}

\item{in_category}{Category to be aggregated over}
}
\value{
A list with entries: \itemize{ \item \code{exposures}: The exposures
  \code{H}, a numeric data frame with \code{l} rows and \code{m} columns,
  \code{l} being the number of aggregated signatures and \code{m} being the
  number of samples \item \code{norm_exposures}: The normalized exposures
  \code{H}, a numeric data frame with \code{l} rows and \code{m} columns,
  \code{l} being the number of aggregated signatures and \code{m} being the
  number of samples \item \code{out_sig_ind_df}: Data frame of the type
  \code{signature_indices_df}, i.e. indicating name, function and
  meta-information of the aggregated signatures.. }
}
\description{
If a valid category (i.e. it matches to a category specified in
in_sig_ind_df) is supplied, then the exposures are aggregated over this
category.
}
\examples{
 NULL

}
\seealso{
\code{\link{LCD_complex_cutoff}}
}
