% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plotPDX}
\alias{plotPDX}
\alias{plotBatch}
\title{Plot batch data}
\usage{
plotPDX(
  object,
  batch = NULL,
  patient.id = NULL,
  drug = NULL,
  model.id = NULL,
  model.color = NULL,
  control.name = NULL,
  max.time = NULL,
  treatment.only = FALSE,
  vol.normal = FALSE,
  impute.value = TRUE,
  concurrent.time = FALSE,
  control.col = "#e41a1c",
  treatment.col = "#377eb8",
  title = "",
  xlab = "Time",
  ylab = "Volume",
  log.y = FALSE,
  SE.plot = c("all", "none", "errorbar", "ribbon"),
  aspect.ratio = c(1, NULL),
  minor.line.size = 0.5,
  major.line.size = 0.7
)

plotBatch(
  object,
  batch = NULL,
  patient.id = NULL,
  drug = NULL,
  control.name = NULL,
  max.time = NULL,
  treatment.only = FALSE,
  vol.normal = FALSE,
  impute.value = TRUE,
  concurrent.time = FALSE,
  control.col = "#6baed6",
  treatment.col = "#fc8d59",
  title = "",
  xlab = "Time",
  ylab = "Volume",
  log.y = FALSE,
  SE.plot = c("all", "none", "errorbar", "ribbon"),
  aspect.ratio = c(1, NULL),
  minor.line.size = 0.5,
  major.line.size = 0.7
)
}
\arguments{
\item{object}{Xeva object.}

\item{batch}{Batch name or experiment design list.}

\item{patient.id}{Patient id from the \code{XevaSet}. Default \code{NULL}.}

\item{drug}{Name of the drug. Default \code{NULL}.}

\item{model.id}{One or multiple model.id. Default \code{NULL}.}

\item{model.color}{Color for \code{model.id}. Default \code{NULL}.}

\item{control.name}{Name of the control sample.}

\item{max.time}{Maximum time point of the plot. Default \code{NULL} will plot complete data.}

\item{treatment.only}{Default \code{FALSE}. Given full data \code{treatment.only=TRUE} will plot data only during treatment.}

\item{vol.normal}{Default \code{FALSE}. If \code{TRUE}, volume will be normalized.}

\item{impute.value}{Default \code{TRUE} will impute values if missing.}

\item{concurrent.time}{Default \code{FALSE}. If \code{TRUE}, cut the batch data such that control and treatment will end at the same time point.}

\item{control.col}{Color for control plots.}

\item{treatment.col}{Color for treatment plots.}

\item{title}{Title of the plot.}

\item{xlab}{Title of the x-axis.}

\item{ylab}{Title of the y-axis.}

\item{log.y}{Default \code{FALSE}. If \code{TRUE}, y-axis will be log-transformed.}

\item{SE.plot}{Plot type. Default \code{"all"} will plot all plots and average curves. Possible values are \code{"all"}, \code{"none"}, \code{"errorbar"}, and \code{"ribbon"}.}

\item{aspect.ratio}{Default \code{1} will create a plot of equal width and height.}

\item{minor.line.size}{Line size for minor lines. Default \code{0.5}.}

\item{major.line.size}{Line size for major lines. Default \code{0.7}.}
}
\value{
A ggplot2 plot with control and treatment batch data.
}
\description{
Plot data for a batch.id, experiment design or model.id
}
\examples{
data(brca)
plotPDX(brca, model.id=c("X.6047.LJ16","X.6047.LJ16.trab"))

plotPDX(brca, batch="X-1004.BGJ398", vol.normal=TRUE)
expDesign <- list(batch.name="myBatch", treatment=c("X.6047.LJ16","X.6047.LJ16.trab"),
             control=c("X.6047.uned"))
plotBatch(brca, batch=expDesign, vol.normal=TRUE)
plotBatch(brca, batch=expDesign, vol.normal=FALSE, SE.plot = "errorbar")
}
