% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_slot_expDesign.R
\name{batchInfo}
\alias{batchInfo}
\alias{batchInfo,XevaSet-method}
\title{Get batch information}
\usage{
batchInfo(
  object,
  batch = NULL,
  model.id = NULL,
  model.id.type = c("any", "control", "treatment")
)

\S4method{batchInfo}{XevaSet}(
  object,
  batch = NULL,
  model.id = NULL,
  model.id.type = c("any", "control", "treatment")
)
}
\arguments{
\item{object}{The Xeva object from which batch information is obtained.}

\item{batch}{Name of the batch. Default \code{NULL}.}

\item{model.id}{Model ID for which need to be searched in the batches. Default \code{NULL}.}

\item{model.id.type}{Type of the model ID in a batch. See the Details section below.}
}
\value{
A \code{Vector} with batch names.
}
\description{
Get batch information from a Xeva dataset.
}
\details{
By default this function will return the names of all the batches present in the
dataset. If a batch specified, it will return the experiment design (control
and treatment model IDs) of that particular batch. If \code{model.id} is specified,
it will return the names of all the batches where this particuler \code{model.id} is present.
If both \code{batch} and \code{model.id} are specified, \code{batch} will take precedent.

For \code{model.id.type}, the default value \code{'any'} will return all the batch IDs
where the given model ID is present in any arm (ie. control or treatment) of the
batch. It can also be restricted to look only for treatment (or control) arm by
specifying the type.
}
\examples{
data(brca)
##to get all the batch names
batch.name <- batchInfo(brca)

##to get a specific batch
batch.design <- batchInfo(brca, batch=batch.name[1])

##to get all the batches where a model.id is present
batchInfo(brca, model.id="X.6047.uned")

}
