% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slope_and_angle.R
\name{angle}
\alias{angle}
\title{compute angle
Computes the angle between two time-volume curves.}
\usage{
angle(
  contr.time = NULL,
  contr.volume = NULL,
  treat.time = NULL,
  treat.volume = NULL,
  degree = TRUE
)
}
\arguments{
\item{contr.time}{Time vector for control.}

\item{contr.volume}{Volume vector for control.}

\item{treat.time}{Time vector for treatment.}

\item{treat.volume}{Volume vector for treatment.}

\item{degree}{Default \code{TRUE} will give angle in degrees and \code{FALSE} will return in radians.}
}
\value{
Returns batch response object.
}
\description{
compute angle
Computes the angle between two time-volume curves.
}
\examples{
contr.time <- treat.time  <- c(0, 3, 7, 11, 18, 22, 26, 30, 32, 35)
contr.volume<- contr.time * tan(60*pi/180)
treat.volume<- treat.time * tan(15*pi/180)
ang <- angle(contr.time, contr.volume, treat.time, treat.volume)
print(ang)
par(pty="s")
xylimit <- range(c(contr.time, contr.volume, treat.time, treat.volume))
plot(contr.time, contr.volume, type = "b", xlim = xylimit, ylim = xylimit)
lines(treat.time, treat.volume, type = "b")
abline(lm(contr.volume~contr.time))
abline(lm(treat.volume~treat.time))
}
