% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_plots.R
\name{get_unknown_ppi_nodes}
\alias{get_unknown_ppi_nodes}
\title{get_unknown_ppi_nodes}
\usage{
get_unknown_ppi_nodes(xina_result, cl)
}
\arguments{
\item{xina_result}{A list containing XINA network analysis results. See \link[XINA]{xina_analysis}}

\item{cl}{the clustering number of XINA clustering results. See \link[XINA]{xina_clustering}}
}
\value{
A data frame containing proteins with no known interactions within the cluster based on the used protein-protein interaction database source
}
\description{
Get proteins with no known interactions within the cluster based on the used protein-protein interaction database source
}
\examples{
# load XINA example data
data(xina_example)

# load the previously processed XINA analysis results
# if you want to learn how to run 'xina_analysis', please see \\link[XINA]{xina_analysis}
data(xina_result_example)

# Extract unknown PPI nodes in the cluster #1
get_unknown_ppi_nodes(xina_result_example, 1)

}
