% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coregulstions.R
\name{alluvial_enrichment_tests}
\alias{alluvial_enrichment_tests}
\title{alluvial_enrichment_tests}
\usage{
alluvial_enrichment_tests(count_table, c1, c2, non_cluster = 0,
  test_type = "fisher")
}
\arguments{
\item{count_table}{A data frame generated by using \link[plyr]{count}.}

\item{c1}{A selected cluster in the first condition.}

\item{c2}{A selected cluster in the second condition.}

\item{non_cluster}{The cluster number for proteins that were not detected in a specific sample. Default is 0.}

\item{test_type}{Enrichment test type.
'fisher' = Fisher's exact test, 'hyper' = Hypergeometric test, 'chisq' = Chi-square test}
}
\value{
P-value of comigration enrichment test and 2x2 table information
}
\description{
Fisher's exact test to calculate the significance over all comigrations.
The following 2x2 table was used to calculate p-value from Fisher's exact test.
To evaluate significance of comigrated proteins from cluster #1 in control to cluster #2 in test condition,
     \tabular{rll}{
           \tab \strong{cluster #1 in control} \tab \strong{other clusters in control}\cr
      \strong{cluster #2 in test}      \tab 65 (TP) \tab 175 (FP)\cr
      \strong{other clusters in test}  \tab 35 (FN) \tab 979 (TN)\cr
     }
'alluvial_enrichment_tests' also provides another statistical methods including Hypergeometric test and Chi-square test.
}
