% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-univar-downstream.R
\name{plotMoranMC}
\alias{plotMoranMC}
\title{Plot Moran/Geary Monte Carlo results}
\usage{
plotMoranMC(
  sfe,
  features,
  sample_id = "all",
  facet_by = c("sample_id", "features"),
  ncol = NULL,
  colGeometryName = NULL,
  annotGeometryName = NULL,
  reducedDimName = NULL,
  ptype = c("density", "histogram", "freqpoly"),
  swap_rownames = NULL,
  name = "moran.mc",
  ...
)
}
\arguments{
\item{sfe}{A \code{SpatialFeatureExperiment} object.}

\item{features}{Features to plot, must be in rownames of the gene count
matrix, colnames of colData or a colGeometry, colnames of cell embeddings
in \code{reducedDim}, or numeric indices of dimension reduction components.}

\item{sample_id}{Sample(s) in the SFE object whose cells/spots to use. Can be
"all" to compute metric for all samples; the metric is computed separately
for each sample.}

\item{facet_by}{Whether to facet by sample_id (default) or features. If
facetting by sample_id, then different features will be plotted in the same
facet for comparison. If facetting by features, then different samples will
be compared for each feature. Ignored if only one sample is specified.}

\item{ncol}{Number of columns if facetting.}

\item{colGeometryName}{Name of a \code{colGeometry} \code{sf} data frame
whose numeric columns of interest are to be used to compute the metric. Use
\code{\link{colGeometryNames}} to look up names of the \code{sf} data
frames associated with cells/spots.}

\item{annotGeometryName}{Name of a \code{annotGeometry} of the SFE object, to
annotate the gene expression plot.}

\item{reducedDimName}{Name of a dimension reduction, can be seen in
\code{\link[SingleCellExperiment]{reducedDimNames}}. \code{colGeometryName} and
\code{annotGeometryName} have precedence over \code{reducedDimName}.}

\item{ptype}{Plot type, one of "density", "histogram", or "freqpoly".}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to
identify features instead of \code{rownames(object)} when labeling plot
elements. If not found in \code{rowData}, then rownames of the gene count
matrix will be used.}

\item{name}{Name under which the Monte Carlo results are stored, which
defaults to "moran.mc". For Geary's C Monte Carlo, the default is
"geary.mc".}

\item{...}{Other arguments passed to \code{\link{geom_density}},
\code{\link{geom_histogram}}, or \code{\link{geom_freqpoly}}, depending on
\code{ptype}.}
}
\value{
A \code{ggplot2} object.
}
\description{
Plot the simulations as a density plot or histogram compared to the observed
Moran's I or Geary's C, with ggplot2 so it looks nicer. Unlike the plotting
function in \code{spdep}, this function can also plot the same feature in
different samples as facets or plot different features or samples together
for comparison.
}
\examples{
library(SpatialFeatureExperiment)
library(SFEData)
sfe <- McKellarMuscleData("small")
colGraph(sfe, "visium") <- findVisiumGraph(sfe)
sfe <- colDataUnivariate(sfe, type = "moran.mc", "nCounts", nsim = 100)
plotMoranMC(sfe, "nCounts")
}
\concept{Plot spatial analysis results}
