% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotGeometry}
\alias{plotGeometry}
\title{Plot geometries without coloring}
\usage{
plotGeometry(
  sfe,
  type = deprecated(),
  MARGIN = deprecated(),
  colGeometryName = NULL,
  annotGeometryName = NULL,
  rowGeometryName = NULL,
  gene = "all",
  sample_id = "all",
  fill = TRUE,
  ncol = NULL,
  bbox = NULL,
  tx_alpha = 1,
  tx_size = 1,
  tx_file = NULL,
  image_id = NULL,
  channel = NULL,
  maxcell = 5e+05,
  show_axes = FALSE,
  dark = FALSE,
  palette = colorRampPalette(c("black", "white"))(255),
  normalize_channels = FALSE
)
}
\arguments{
\item{sfe}{A \code{SpatialFeatureExperiment} object.}

\item{type}{Name of the geometry associated with the MARGIN of interest for
which to compute the graph.}

\item{MARGIN}{Just like in \code{\link{apply}}, where 1 stands for row, 2
stands for column. Here, in addition, 3 stands for annotation, to query the
\code{\link[SpatialFeatureExperiment]{annotGeometries}}, such as nuclei segmentation in a Visium data}

\item{colGeometryName}{Name of a \code{colGeometry} \code{sf} data frame
whose numeric columns of interest are to be used to compute the metric. Use
\code{\link{colGeometryNames}} to look up names of the \code{sf} data
frames associated with cells/spots.}

\item{annotGeometryName}{Name of a \code{annotGeometry} of the SFE object, to
annotate the gene expression plot.}

\item{rowGeometryName}{Name of a \code{rowGeometry} of the SFE object to
plot.}

\item{gene}{Character vector of names of genes to plot. If "all" then
transcript spots of all genes are plotted.}

\item{sample_id}{Sample(s) in the SFE object whose cells/spots to use. Can be
"all" to compute metric for all samples; the metric is computed separately
for each sample.}

\item{fill}{Logical, whether to fill polygons.}

\item{ncol}{Number of columns if plotting multiple features. Defaults to
\code{NULL}, which means using the same logic as \code{facet_wrap}, which
is used by \code{patchwork}'s \code{\link{wrap_plots}} by default.}

\item{bbox}{A bounding box to specify a smaller region to plot, useful when
the dataset is large. Can be a named numeric vector with names "xmin",
"xmax", "ymin", and "ymax", in any order. If plotting multiple samples, it
should be a matrix with sample IDs as column names and "xmin", "ymin",
"xmax", and "ymax" as row names. If multiple samples are plotted but
\code{bbox} is a vector rather than a matrix, then the same bounding box
will be used for all samples. You may see points at the edge of the
geometries if the intersection between the bounding box and a geometry
happens to be a point there. If \code{NULL}, then the entire tissue is
plotted.}

\item{tx_alpha}{Transparency for transcript spots, helpful when the
transcript spots are overplotting.}

\item{tx_size}{Point size for transcript spots.}

\item{tx_file}{File path to GeoParquet file of the transcript spots if you
don't wish to load all transcript spots into the SFE object. See
\code{\link{formatTxSpots}} on generating such a GeoParquet file.}

\item{image_id}{ID of the image to plot behind the geometries. If
\code{NULL}, then not plotting images. Use \code{\link{imgData}} to see
image IDs present. To plot multiple grayscale images as different RGB
channels, use a named vector here, whose names are channel names (r, g, b),
and values are image_ids of the corresponding images. The RGB colorization
may not be colorblind friendly. When plotting multiple samples, it is
assumed that the same image_id is used for each channel across different
samples.}

\item{channel}{Numeric vector indicating which channels in a multi-channel
image to plot. If \code{NULL}, grayscale is plotted if there is 1 channel
and RGB for the first 3 channels. The numeric vector can be named (r, g, b)
to indicate which channel maps to which color. The RGB colorization may not
be colorblind friendly. This argument cannot be specified while
\code{image_id} is a named vector to plot different grayscale images as
different channels.}

\item{maxcell}{Maximum number of pixels to plot in the image. If the image is
larger, it will be resampled so it have less than this number of pixels to
save memory and for faster plotting. We recommend reducing this number when
plotting multiple facets.}

\item{show_axes}{Logical, whether to show axes.}

\item{dark}{Logical, whether to use dark theme. When using dark theme, the
palette will have lighter color represent higher values as if glowing in
the dark. This is intended for plotting gene expression on top of
fluorescent images.}

\item{palette}{Vector of colors to use to color grayscale images.}

\item{normalize_channels}{Logical, whether to normalize each channel of the
image individually. Should be \code{FALSE} for bright field color images
such as H&E but should set to \code{TRUE} for fluorescent images.}
}
\value{
A \code{ggplot} object.
}
\description{
Different samples are plotted in separate facets. When multiple geometries
are plotted at the same time, they will be differentiated by color, by
default using the \code{dittoSeq} palette, but this can be overridden with
\code{scale_color_*} functions. Transcript spots of different genes are
differentiated by point shape if plotted, so the number of genes plotted
shouldn't exceed about 6 or a warning will be issued.
}
\examples{
library(SFEData)
sfe1 <- McKellarMuscleData("small")
sfe2 <- McKellarMuscleData("small2")
sfe <- cbind(sfe1, sfe2)
sfe <- removeEmptySpace(sfe)
plotGeometry(sfe, colGeometryName = "spotPoly")
plotGeometry(sfe, annotGeometryName = "myofiber_simplified")
}
\concept{Spatial plotting}
