% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.R
\name{calculateMultivariate}
\alias{calculateMultivariate}
\alias{calculateMultivariate,ANY,SFEMethod-method}
\alias{calculateMultivariate,ANY,character-method}
\alias{calculateMultivariate,SpatialFeatureExperiment,ANY-method}
\alias{runMultivariate}
\title{Multivariate spatial data analysis}
\usage{
\S4method{calculateMultivariate}{ANY,SFEMethod}(
  x,
  type,
  listw = NULL,
  transposed = FALSE,
  zero.policy = TRUE,
  p.adjust.method = "BH",
  ...
)

\S4method{calculateMultivariate}{ANY,character}(x, type, listw = NULL, transposed = FALSE, ...)

\S4method{calculateMultivariate}{SpatialFeatureExperiment,ANY}(
  x,
  type,
  colGraphName = 1L,
  subset_row = NULL,
  exprs_values = "logcounts",
  sample_action = c("joint", "separate"),
  BPPARAM = SerialParam(),
  ...
)

runMultivariate(
  x,
  type,
  colGraphName = 1L,
  subset_row = NULL,
  exprs_values = "logcounts",
  sample_action = c("joint", "separate"),
  BPPARAM = SerialParam(),
  name = NULL,
  dest = c("reducedDim", "colData"),
  ...
)
}
\arguments{
\item{x}{A numeric matrix whose rows are features/genes, or a
\code{SpatialFeatureExperiment} (SFE) object with such a matrix in an
assay.}

\item{type}{An \code{\link{SFEMethod}} object, or a string matching the name
of an \code{SFEMethod} object. The methods mentioned above correspond to
\code{SFEMethod} objects already implemented in the Voyager package. Use
\code{\link{listSFEMethods}} to see which methods are available. You can
implement new \code{SFEMethod} objects to apply Voyager functions to other
spatial analysis methods. This is in part inspired by the \code{caret},
\code{parsnip}, and \code{BiocSingular} packages.}

\item{listw}{Weighted neighborhood graph as a \code{spdep} \code{listw}
object. Not used when the method specified in \code{type} does not use a
spatial neighborhood graph, such as the variogram.}

\item{transposed}{Logical, whether the matrix has genes in columns and cells
in rows.}

\item{zero.policy}{default \code{attr(listw, "zero.policy")} as set when \code{listw} was created, if attribute not set, use global option value; if TRUE assign zero to the lagged value of zones without neighbours, if FALSE assign NA}

\item{p.adjust.method}{Method to correct for multiple testing, passed to
\code{\link[spdep]{p.adjustSP}}. Methods allowed are in
\code{\link{p.adjust.methods}}.}

\item{...}{Extra arguments passed to the specific multivariate method. For
example, see \code{\link{multispati_rsp}} for arguments for MULTISPATI PCA.
See \code{\link{localC}} for arguments for "localC_multi" and
"localC_perm_multi".}

\item{colGraphName}{Name of the listw graph in the SFE object that
corresponds to entities represented by columns of the gene count matrix.
Use \code{\link{colGraphNames}} to look up names of the available graphs
for cells/spots. Note that for multiple \code{sample_id}s, it is assumed
that all of them have a graph of this same name.}

\item{subset_row}{Vector specifying the subset of features to use for dimensionality reduction.
This can be a character vector of row names, an integer vector of row indices or a logical vector.}

\item{exprs_values}{Integer scalar or string indicating which assay of x
contains the expression values.}

\item{sample_action}{Character, either "joint" or "separate". Spatial methods
depend on the spatial coordinates and/or spatial neighborhood graph, which
is why \code{SpatialExperiment} uses \code{sample_id} to keep coordinates
from different samples separate. Some spatial methods can be sensibly run
jointly for multiple samples. In this case, "joint" will run the method
jointly for all samples, and "separate" will run the method separately for
each sample and concatenate the results.}

\item{BPPARAM}{A \code{\link{BiocParallelParam}} object specifying whether
and how computing the metric for numerous genes shall be parallelized. This
is to parallelize computation across multiple samples when there are a
large number of samples. Be cautious if using an optimized BLAS for matrix
operations that supports multithreading.}

\item{name}{Name to use to store the results, defaults to the name in the
\code{SFEMethod} object passed to argument \code{type}. Can be set to
distinguish between results from the same method but with different
parameters.}

\item{dest}{Character, either "reducedDim" or "colData". If the output of the
multivariate method is a matrix or array, as in spatially informed
dimension reduction, then the only option is "reducedDim", so the results
will be stored in \code{\link{reducedDim}} of the SFE object. If the output
is a vector, as in the multivariate version of \code{\link{localC}}, then
it will be sotred in \code{colData}. Data frame output, such as from
\code{localC_perm}, can be stored in either \code{reducedDim} or
\code{colData}.}
}
\value{
In \code{calculateMultivariate}, a matrix for cell embeddings whose
  attributes include loadings and eigenvalues if relevant, ready to be added
  to the SFE object with \code{reducedDim} setter. For \code{run*}, a
  \code{SpatialFeatureExperiment} object with the results added. See Details
  for where the results are stored.
}
\description{
These functions perform multivariate spatial data analysis, usually spatially
informed dimension reduction.
}
\details{
For the argument \code{type}, this package supports "multispati" for
MULTISPATI PCA, "localC_multi" for a multivariate generalization of Geary's
C, "localC_perm_multi" for the multivariate Geary's C with permutation
testing, and "gwpca" for geographically weighted PCA.
}
\examples{
# example code
library(SFEData)
library(scater)
library(scran)
sfe <- McKellarMuscleData()
sfe <- logNormCounts(sfe)
gvs <- modelGeneVar(sfe)
hvgs <- getTopHVGs(gvs, fdr.threshold = 0.05)
colGraph(sfe, "visium") <- findVisiumGraph(sfe)
sfe <- runMultivariate(sfe, "multispati", subset_row = hvgs)
}
\references{
Dray, S., Said, S. and Debias, F. (2008) Spatial ordination of
vegetation data using a generalization of Wartenberg's multivariate spatial
correlation. Journal of vegetation science, 19, 45-56.

Anselin, L. (2019), A Local Indicator of Multivariate Spatial Association:
Extending Geary's c. Geogr Anal, 51: 133-150. doi:10.1111/gean.12164
}
\concept{Spatial statistics}
