% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDSplot.R
\name{MDSplot}
\alias{MDSplot}
\alias{MDSplot,ANY-method}
\title{Multi Dimensional Scale (MDS) plot}
\usage{
MDSplot(object, type = "GOterms", file = NULL)

\S4method{MDSplot}{ANY}(object, type = "GOterms", file = NULL)
}
\arguments{
\item{object}{a \code{\link{GO_SS-class}} or \code{\link{GO_clusters-class}} objects from distances computed with \code{\link{compute_SS_distances}}.}

\item{type}{could be "GOterms" to display GOterms MDSplot, or "GOclusters" to display GOclusters MDSplot.}

\item{file}{static image output file name (default to NULL).}
}
\value{
a MDS plot.
}
\description{
Generate a Multi Dimensional Scale (MDS) plot from distance objects.
}
\details{
This method build and display the javascript MDSplot (if \code{file}=NULL) from \code{\link{GO_SS-class}} or \code{\link{GO_clusters-class}}
objects.\cr
A static png image could be printed by setting \code{file} argument.
}
\examples{
# load data example
utils::data(
 myGOs,
 package="ViSEAGO"
)
\dontrun{
# compute GO terms Semantic Similarity distances
myGOs<-ViSEAGO::compute_SS_distances(
    myGOs,
    distance="Wang"
)

# build MDS plot for a GO_SS-class distance object
ViSEAGO::MDSplot(myGOs,"GOterms")

# GOtermsHeatmap with default parameters
Wang_clusters_wardD2<-ViSEAGO::GOterms_heatmap(
    myGOs,
    showIC=TRUE,
    showGOlabels=TRUE,
    GO.tree=list(
        tree=list(
            distance="Wang",
            aggreg.method="ward.D2",
            rotate=NULL
        ),
        cut=list(
            dynamic=list(
                pamStage=TRUE,
                pamRespectsDendro=TRUE,
                deepSplit=2,
                minClusterSize =2
            )
        )
    ),
    samples.tree=NULL
)

# build MDS plot for a GO_clusters-class distance object, highlighting GO terms clusters.
ViSEAGO::MDSplot(
    Wang_clusters_wardD2,
    "GOterms"
)

# compute clusters of GO terms Semantic Similarity distances
Wang_clusters_wardD2<-ViSEAGO::compute_SS_distances(
    Wang_clusters_wardD2,
    distance="BMA"
)

# GOclusters heatmap
Wang_clusters_wardD2<-ViSEAGO::GOclusters_heatmap(
    Wang_clusters_wardD2,
    tree=list(
        distance="BMA",
        aggreg.method="ward.D2",
        rotate=NULL
    )
)

# build MDS plot for a GO_clusters-class distance object, highlighting GO groups clusters.
ViSEAGO::MDSplot(
    Wang_clusters_wardD2,
    "GOclusters"
)
}
}
\concept{GO_terms GO_clusters semantic_similarity visualization}
