% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical.R
\name{vennEnrichment}
\alias{vennEnrichment}
\title{Perform enrichment analysis on set intersections}
\usage{
vennEnrichment(
  object,
  annotation,
  id_col,
  category_col,
  subsets = NULL,
  min_overlap = 3,
  adjust.method = "BH",
  sig_threshold = 0.05
)
}
\arguments{
\item{object}{A Venn object}

\item{annotation}{A data frame with annotation data (e.g., Gene Ontology terms)}

\item{id_col}{Column in the annotation data frame containing identifiers matching elements in the Venn object}

\item{category_col}{Column in the annotation data frame containing category information}

\item{subsets}{Character vector of subset names to analyze (default: NULL, all subsets)}

\item{min_overlap}{Minimum number of elements a category must share with a subset (default: 3)}

\item{adjust.method}{Method for multiple testing correction (default: "BH")}

\item{sig_threshold}{Significance threshold for p-values (default: 0.05)}
}
\value{
A data.frame with enrichment analysis results
}
\description{
Performs enrichment analysis to identify overrepresented categories in set intersections
}
\examples{
# Create a Venn object with gene sets
A <- sample(1:1000, 100, replace = FALSE)
B <- sample(1:1000, 150, replace = FALSE)
C <- sample(1:1000, 120, replace = FALSE)
res <- venndetail(list(A = A, B = B, C = C))

# Create simulated annotation data
gene_ids <- 1:1000
categories <- sample(c("Category1", "Category2", "Category3", "Category4"),
                     1000, replace = TRUE)
anno <- data.frame(GeneID = gene_ids, Category = categories)

# Perform enrichment analysis
enrichment <- vennEnrichment(res, anno, "GeneID", "Category")
}
\author{
Kai Guo
}
