% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.Venn}
\alias{plot.Venn}
\title{Plot a Venn object}
\usage{
\method{plot}{Venn}(
  x,
  type = "venn",
  title = NULL,
  interactive = FALSE,
  filename = NULL,
  width = 8,
  height = 6,
  dpi = 300,
  fill = NULL,
  alpha = 0.5,
  labels = TRUE,
  counts = TRUE,
  showNumbers = TRUE,
  numberSize = 4,
  numberColor = "black",
  labelSize = 4,
  labelColor = "black",
  borderCol = FALSE,
  fillCol = TRUE,
  fixedCoords = TRUE,
  xlim = c(0, 1),
  ylim = c(0, 1),
  show_percentages = TRUE,
  show_unique_only = FALSE,
  scaled = FALSE,
  subset = NULL,
  top = 31,
  min = 0,
  color = NULL,
  revcolor = "lightgrey",
  any = NULL,
  show.number = TRUE,
  show.x = TRUE,
  sep = "_",
  log = FALSE,
  base = NULL,
  percentage = FALSE,
  nintersects = 40,
  min_size = 1,
  sets_bar_color = NULL,
  main_bar_color = "steelblue",
  point_size = 3,
  line_size = 1,
  show_numbers = TRUE,
  sort_intersections_by = "freq",
  sort_sets_by = "size",
  sort_sets_decreasing = TRUE,
  custom_sets_order = NULL,
  sort_intersections_decreasing = TRUE,
  custom_intersections_order = NULL,
  intersection_color = "black",
  highlight_intersections = NULL,
  highlight_color = "darkorange",
  empty_point_size = 1.5,
  bar_width = 0.7,
  text_angle = 0,
  text_size = 10,
  set_label_size = 3,
  intersection_label_size = 3,
  point_outline_color = "black",
  point_stroke = 0.3,
  set_size_show_values = TRUE,
  intersection_size_show_values = TRUE,
  show_empty_intersections = FALSE,
  show_set_labels = TRUE,
  plot_margin = 0.5,
  height_ratio = 0.7,
  width_ratio = 0.3,
  bar_offset = -0.01,
  set_text_size = 10,
  intersection_title = "Intersection Size",
  set_size_title = "Set Size",
  matrix_point_shape = 21,
  number_color_threshold = 0.75,
  number_colors = c(on_bar = "black", off_bar = "black"),
  theme_params = list(background_color = "white", grid_color = "grey92", axis_text_color
    = "black", use_grid = TRUE, border_color = NA),
  return_data = FALSE,
  order = FALSE,
  textsize = 5,
  theme = ggplot2::theme_light(),
  xlabel = NULL,
  ylabel = NULL,
  ...
)
}
\arguments{
\item{x}{A Venn object}

\item{type}{Type of plot: "venn" (traditional Venn diagram), "vennpie" (pie-chart style),
"upset" (UpSet plot), or "bar" (bar plot of subset sizes)}

\item{title}{Optional plot title}

\item{interactive}{Logical: create an interactive plot? Default: FALSE}

\item{filename}{Optional file name to save the plot}

\item{width}{Width of the saved plot (default: 8)}

\item{height}{Height of the saved plot (default: 6)}

\item{dpi}{Resolution in dots per inch (default: 300)}

\item{...}{Additional arguments passed to the specific plotting function}
}
\value{
A ggplot2 or plotly object
}
\description{
Unified plotting function for Venn objects that supports multiple visualization types
}
\section{Parameters for Traditional Venn Diagram (type = "venn")}{

\describe{
  \item{fill}{Colors for filling the circles}
  \item{alpha}{Transparency level for the circles (0-1), default: 0.5}
  \item{labels}{Logical: show set labels? Default: TRUE}
  \item{counts}{Logical: show counts? Default: TRUE}
  \item{showNumbers}{Logical: whether to show counts and percentages in each region, default: TRUE}
  \item{numberSize}{Size of the count labels, default: 4}
  \item{numberColor}{Color of the count labels, default: "black"}
  \item{labelSize}{Size of the set labels, default: 4}
  \item{labelColor}{Color of the set labels, default: "black"}
  \item{borderCol}{Logical: whether to color the borders of circles, default: FALSE}
  \item{fillCol}{Logical: whether to fill circles with colors, default: TRUE}
  \item{fixedCoords}{Logical: whether to use fixed coordinates, default: TRUE}
  \item{xlim}{Vector with 2 numbers, x axis limits for the venn diagram, default: c(0, 1)}
  \item{ylim}{Vector with 2 numbers, y axis limits for the venn diagram, default: c(0, 1)}
  \item{show_percentages}{Logical: show percentages alongside counts? Default: TRUE}
  \item{show_unique_only}{Logical: show counts only for unique elements? Default: FALSE}
  \item{scaled}{Logical: scale circles by set size? Default: FALSE}
}
}

\section{Parameters for Venn-Pie Plot (type = "vennpie")}{

\describe{
  \item{subset}{Character vector of subset names to highlight}
  \item{top}{Maximum number of subsets to display, default: 31}
  \item{min}{Minimum number of sets an element must be in, default: 0}
  \item{color}{Optional vector of colors for the subsets}
  \item{revcolor}{Color for non-highlighted subsets, default: "lightgrey"}
  \item{any}{Highlight subsets shared by exactly this many sets}
  \item{show.number}{Logical: show counts in labels? Default: TRUE}
  \item{show.x}{Logical: show subset labels? Default: TRUE}
  \item{sep}{Character separator for subset names, default: "_"}
  \item{log}{Logical: use log scale for counts? Default: FALSE}
  \item{base}{Base for log transformation if log=TRUE}
  \item{percentage}{Logical: show percentages instead of counts? Default: FALSE}
}
}

\section{Parameters for UpSet Plot (type = "upset")}{

\describe{
  \item{nintersects}{Maximum number of intersections to show, default: 40}
  \item{min_size}{Minimum intersection size to include, default: 1}
  \item{sets_bar_color}{Colors for the set size bars}
  \item{main_bar_color}{Color for the intersection size bars, default: "steelblue"}
  \item{point_size}{Size of points in the matrix, default: 3}
  \item{line_size}{Width of lines in the matrix, default: 1}
  \item{show_numbers}{Logical: show counts on bars? Default: TRUE}
  \item{sort_intersections_by}{How to sort intersections: "freq" (default), "degree", or "custom"}
  \item{sort_sets_by}{How to sort sets: "size" (default), "name", or "custom"}
  \item{sort_sets_decreasing}{Whether to sort sets in decreasing order, default: TRUE}
  \item{custom_sets_order}{Custom order for sets if sort_sets_by="custom"}
  \item{sort_intersections_decreasing}{Whether to sort intersections in decreasing order, default: TRUE}
  \item{custom_intersections_order}{Custom order for intersections if sort_intersections_by="custom"}
  \item{intersection_color}{Color for intersection dots and lines, default: "black"}
  \item{highlight_intersections}{Vector of intersection IDs to highlight}
  \item{highlight_color}{Color for highlighted intersections, default: "darkorange"}
  \item{empty_point_size}{Size of empty points in the matrix, default: 1.5}
  \item{bar_width}{Width of bars (0-1 scale), default: 0.7}
  \item{text_angle}{Angle for text labels, default: 0}
  \item{text_size}{Size of text in the plot, default: 10}
  \item{set_label_size}{Size of set size labels, default: 3}
  \item{intersection_label_size}{Size of intersection size labels, default: 3}
  \item{point_outline_color}{Color for the outline of points, default: "black"}
  \item{point_stroke}{Width of point outline, default: 0.3}
  \item{set_size_show_values}{Whether to show set size values, default: TRUE}
  \item{intersection_size_show_values}{Whether to show intersection size values, default: TRUE}
  \item{show_empty_intersections}{Whether to show empty intersections, default: FALSE}
  \item{show_set_labels}{Whether to show set labels, default: TRUE}
  \item{plot_margin}{Margin around the plots in cm, default: 0.5}
  \item{height_ratio}{Ratio of matrix to total height, default: 0.7}
  \item{width_ratio}{Ratio of set size to total width, default: 0.3}
  \item{bar_offset}{Horizontal offset for top bars, default: -0.01}
  \item{set_text_size}{Size of set labels, default: 10}
  \item{intersection_title}{Title for the intersection size plot, default: "Intersection Size"}
  \item{set_size_title}{Title for the set size plot, default: "Set Size"}
  \item{matrix_point_shape}{Shape of the dots in the matrix (21=filled circle), default: 21}
  \item{number_color_threshold}{Fraction of max value where number color switches, default: 0.75}
  \item{number_colors}{Named vector with colors for labels on/off bars, default: c(on_bar="black", off_bar="black")}
  \item{theme_params}{List of theme parameters for customization}
  \item{return_data}{Whether to return the data along with the plot, default: FALSE}
}
}

\section{Parameters for Bar Plot (type = "bar")}{

\describe{
  \item{order}{Logical: should bars be ordered by count? Default: FALSE}
  \item{textsize}{Numeric: size of text labels above bars, default: 5}
  \item{color}{Optional vector of colors for the bars}
  \item{theme}{The ggplot2 theme to use, default: theme_light()}
  \item{xlabel}{Optional x-axis label}
  \item{ylabel}{Optional y-axis label}
}
}

\examples{
# Create a Venn object
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
res <- venndetail(list(A = A, B = B, C = C))

# Traditional Venn diagram
plot(res, type = "venn")

# Venn diagram with custom colors and transparency
plot(res, type = "venn", fill = c("red", "blue", "green"), alpha = 0.3)

# Venn-pie visualization
plot(res, type = "vennpie")

# Venn-pie with highlighted subsets
plot(res, type = "vennpie", any = 2, log = TRUE)

# UpSet plot
plot(res, type = "upset")

# UpSet plot with custom sorting and highlighting
plot(res, type = "upset",
     sort_sets_by = "size",
     highlight_intersections = c(1, 2),
     highlight_color = "red")

# Bar plot of subset sizes
plot(res, type = "bar")

# Ordered bar plot with larger text
plot(res, type = "bar", order = TRUE, textsize = 8)

# Save plot to file
plot(res, type = "venn", filename = "my_venn.png", width = 10, height = 8)

# Create interactive plot
if(interactive()) {
  plot(res, type = "venn", interactive = TRUE)
}
}
\author{
Kai Guo
}
