% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/methods-HMM.R
\docType{class}
\name{HMM-class}
\alias{HMM-class}
\alias{HMM}
\alias{state,HMM-method}
\alias{show,HMM-method}
\title{Container for the segmented data and the 6-state HMM model parameters}
\usage{
HMM(
  granges = GRanges(),
  param = HmmParam(),
  posterior = matrix(),
  filters = FilterParam()
)

\S4method{state}{HMM}(object)

\S4method{show}{HMM}(object)
}
\arguments{
\item{granges}{a \code{GRanges} object}

\item{param}{a \code{HmmParam} object}

\item{posterior}{matrix of posterior probabilities}

\item{filters}{an object of class \code{FilterParam}}

\item{object}{a \code{HMM} object}
}
\description{
The contructor \code{HMM} creates and object of class
\code{HMM}. Not typically called directly by the user.
}
\section{Slots}{

\describe{
\item{\code{granges}}{a \code{GRanges} object}

\item{\code{param}}{a \code{HmmParam} object}

\item{\code{posterior}}{a matrix of posterior probabilities}

\item{\code{filters}}{a \code{FilterParam} object}
}}

\examples{
data(snp_exp)
hmm_list <- hmm2(snp_exp[,1])
resultsFirstSample <- hmm_list[[1]]
resultsFirstSample
HMM()
}
\seealso{
\code{\link{hmm2}}
}
