% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMfinder.R
\name{BMfinder}
\alias{BMfinder}
\title{Discover bimodal distrubition features}
\usage{
BMfinder(x, p.value = 0.01, maf = 0.05, miss = 0.05, fold = 2, log = FALSE, 
        cores = detectCores() - 1)
}
\arguments{
\item{x}{a numeric matrix with feature rows and sample columns, e.g.,
splicing score matrix from \code{\link{spliceGenome}} or
\code{\link{spliceGene}} function.}

\item{p.value}{p.value threshold for bimodal distrubition test}

\item{maf}{minor allele frequency threshold in k-means clustering}

\item{miss}{missing grouping rate threshold in k-means clustering}

\item{fold}{fold change threshold between the two groups}

\item{log}{whether the scores are to be logarithmic. If TRUE, all the scores
are log2 tranformed before k-means clustering: x = log2(x+1).}

\item{cores}{threads to be used. This value is passed
to \bold{?mclapply} in \bold{parallel} package}
}
\value{
a matrix with feature rows and sample columns.
}
\description{
Find bimodal distrubition features and
divide the samples into 2 groups by k-means clustering.
}
\details{
The matrix contains 1, 2 and NA, and
values of 'x' in group 2 are larger than group 1.
}
\examples{
data(rice.bg)
score<-spliceGene(rice.bg,'MSTRG.183',junc.type='score')
score<-round(score,2)
as<-BMfinder(score,cores=1) # 4 bimodal distrubition features found

##compare
as
score[rownames(score)\%in\%rownames(as),]
}
