% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runBreakaway.R
\name{runBreakaway}
\alias{runBreakaway}
\alias{runBreakaway,clonoStats-method}
\title{Clonotype richness estimation with Breakaway}
\usage{
runBreakaway(x, ...)

\S4method{runBreakaway}{clonoStats}(x, nof1 = FALSE, ...)
}
\arguments{
\item{x}{A \code{\link{clonoStats}} object.}

\item{...}{Additional arguments passed to \code{breakaway} or
\code{breakaway_nof1}.}

\item{nof1}{logical. Indicates whether to use the \code{breakaway_nof1}
function, for abundance data that may contain spurious singletons.}
}
\value{
A list of \code{alpha_estimate} objects, one per group, containing
detailed results of running the Breakaway estimator on the vector of
clonotype frequencies from that group.
}
\description{
This function uses the Breakaway method to estimate the
clonotype richness (total number of clonotypes) present in each group of a
\code{clonoStats} object.
}
\examples{
data('contigs')
x <- clonoStats(contigs, method = 'unique')
runBreakaway(x)

}
\references{
Willis, A. and Bunge, J. (2015). Estimating diversity via frequency ratios.
\emph{Biometrics}.

Willis, A. (2015). Species richness estimation with high diversity but
spurious singletons. \emph{arXiv}.
}
