% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapseEvents.R
\name{collapseEvents}
\alias{collapseEvents}
\title{Collapse events per sample and chromosome}
\usage{
collapseEvents(subset_df)
}
\arguments{
\item{subset_df}{A data.frame containing event-level data with columns:
ID: Sample identifier.
seqnames: Chromosome name.
start: Start position of the event.
end: End position of the event.
group: Event group/class.
n_mendelian_error: Number of Mendelian errors in the event.}
}
\value{
A data.frame with collapsed events and columns:
ID, seqnames, group
n_events: Number of events collapsed
total_mendelian_error: Sum of Mendelian errors across events
total_size: Total genomic span size covered by events
collapsed_events: Comma-separated list of collapsed events
min_start, max_end: Genomic span of collapsed block
}
\description{
This function collapses genomic events per individual, chromosome, and group,
summarising the number of events, total Mendelian errors, the total span size,
and a string listing all merged event coordinates.
}
\examples{
all_events <- data.frame(
ID = c("S1", "S1", "S1", "S2", "S2"),
seqnames = c("1", "1", "1", "2", "2"),
start = c(100, 150, 300, 500, 550),
end = c(120, 180, 320, 520, 580),
group = c("iso_mat", "iso_mat", "het_pat", "iso_mat", "iso_mat"),
n_mendelian_error = c(5, 10, 2, 50, 30),
stringsAsFactors = FALSE
)
out <- collapseEvents(all_events)
}
