% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotUMI4C.R
\name{plotTrend}
\alias{plotTrend}
\title{Plot adaptative smoothen trend}
\usage{
plotTrend(umi4c, grouping = NULL, colors = NULL, xlim = NULL, ylim = NULL)
}
\arguments{
\item{umi4c}{\linkS4class{UMI4C} object as generated by \code{\link{makeUMI4C}}.}

\item{grouping}{Grouping used for the different samples. If none available or 
want to add new groupings, run \code{\link{addGrouping}}.}

\item{colors}{Named vector of colors to use for plotting for each group.}

\item{xlim}{Limits for the plot x axis (genomic coordinates).}

\item{ylim}{Limits of the trend y axis.}
}
\value{
Produces the adaptative trend plot, showing average UMIs at each
position taking into account the minimum number of molecules used to merge
restriction fragments.
}
\description{
Plot adaptative smoothen trend
}
\examples{
data("ex_ciita_umi4c")

plotTrend(ex_ciita_umi4c)
}
