% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contactsUMI4C.R
\name{.singlePrepUMI4C}
\alias{.singlePrepUMI4C}
\title{Prepar fastq files at a given barcode.}
\usage{
.singlePrepUMI4C(
  fq_R1,
  fq_R2,
  bait_seq,
  bait_pad,
  res_enz,
  prep_dir,
  numb_reads = 1e+09
)
}
\arguments{
\item{fq_R1}{Fastq file R1.}

\item{fq_R2}{Fastq file R2.}

\item{bait_seq}{Character containing the bait primer sequence.}

\item{bait_pad}{Character containing the pad sequence (sequence between the
bait primer and the restriction enzyme sequence).}

\item{res_enz}{Character containing the restriction enzyme sequence.}

\item{prep_dir}{Prep directory.}

\item{numb_reads}{Number of lines from the FastQ file to load in each loop.
If having memory size problems, change it to a smaller number. Default=1e9.}
}
\value{
Creates a compressed FASTQ file in \code{wk_dir/prep} named
\code{basename(Fastq)).fq.gz}, containing the filtered reads with the UMI
sequence in the header. A data.frame object with the statisitics is also
returned.
}
\description{
Prepar fastq files at a given barcode.
}
