% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_asPhylo.R
\name{asPhylo}
\alias{asPhylo}
\title{Convert a data frame to a phylo object}
\usage{
asPhylo(data, column_order = NULL, asNA = NULL)
}
\arguments{
\item{data}{A data frame or matrix.}

\item{column_order}{A vector that includes the column names of data to
reorder columns of \code{data}. Default is NULL, the original order of
\code{data} is kept.}

\item{asNA}{This specifies strings that are considered as NA}
}
\value{
a phylo object
}
\description{
\code{asPhylo} converts a data frame to a phylo object. Compared to
\code{toTree}, \code{asPhylo} allows the output tree to have different number
of nodes in paths connecting leaves to the root.
}
\details{
The last column is used as the leaf nodes
}
\examples{

library(ggtree)

# Example 0:
taxTab <- data.frame(R1 = rep("A", 5),
                     R2 = c("B1", rep("B2", 4)),
                     R3 = paste0("C", 1:5))
# Internal nodes: their labels are prefixed with colnames of taxTab
#  e.g., R2:B2
taxTree <- asPhylo(data = taxTab)
ggtree(taxTree) + 
 geom_text2(aes(label = label), color = "red", vjust = 1) + 
 geom_nodepoint()
 
 # (Below gives the same output as toTree)
 taxTab$R1 <- paste0("R1:", taxTab$R1)
 taxTab$R2 <- paste0("R2:", taxTab$R2)
 taxTree <- asPhylo(data = taxTab)
# viz the tree           
 ggtree(taxTree) + 
 geom_text2(aes(label = label), color = "red", vjust = 1) + 
 geom_nodepoint()
 
# Example 1
df1 <- rbind.data.frame(c("root", "A1", "A2", NA),
                        c("root", "B1", NA, NA))
colnames(df1) <- paste0("L", 1:4)
tree1 <- asPhylo(df1)

ggtree(tree1, color = "grey") +
geom_nodepoint() +
   geom_text2(aes(label = label), angle = 90,
               color = "red", vjust = 2,
               size = 4)
               
# Example 2
df2 <- data.frame(Group_1 = rep("Root", 11),
                  Group_2 = rep(c(13, 21), c(9, 2)),
                  Group_3 = rep(c(14, 18, "unknown"), c(5, 4, 2)),
                  Group_4 = rep(c(15, "unknown", 19, "unknown"), c(4, 1, 3, 3)),
                  Group_5 = rep(c(16, "unknown", 20, "unknown"), c(3, 2, 2, 4)),
                  Group_6 = rep(c(17, "unknown"), c(2, 9)),
                  LEAF = 1:11)
                  
tree2 <- asPhylo(df2, asNA = "unknown")

ggtree(tree2, color = "grey") +
geom_nodepoint() +
   geom_text2(aes(label = label), angle = 90,
               color = "red", vjust = 2,
               size = 4) 
               
# Example 3
df3 <- df2
df3[10:11, 3] <- ""                                            
 
tree3 <- asPhylo(df3, asNA = c("unknown", ""))

ggtree(tree3, color = "grey") +
geom_nodepoint() +
   geom_text2(aes(label = label), angle = 90,
               color = "red", vjust = 2,
               size = 4) 
}
\author{
Ruizhu Huang
}
