% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_asLeaf.R
\name{asLeaf}
\alias{asLeaf}
\title{change internal nodes to leaf nodes}
\usage{
asLeaf(tree, node)
}
\arguments{
\item{tree}{A phylo object.}

\item{node}{A numeric or character vector. It specifies internal nodes that
are changed to leaves via their node labels or numbers.}
}
\value{
A phylo object.
}
\description{
\code{asLeaf} updates a \code{phylo} tree by changing the specified internal
nodes to leaf nodes. In other words, the descendant nodes of the specified
internal nodes are removed.
}
\examples{
library(ggtree)
data(tinyTree)
ggtree(tinyTree, ladderize = FALSE) +
    geom_text2(aes(label = label), color = "darkorange",
           hjust = -0.1, vjust = -0.7) +
    geom_text2(aes(label = node), color = "darkblue",
               hjust = -0.5, vjust = 0.7) +
    geom_hilight(node = 16) +
    geom_point2()

# remove the blue branch
NT1 <- asLeaf(tree = tinyTree, node = 16)

ggtree(NT1, ladderize = FALSE) +
    geom_text2(aes(label = label), color = "darkorange",
               hjust = -0.1, vjust = -0.7) +
    geom_point2()

# if mergeSingle = TRUE, the node (Node_17) is removed.
NT2 <- asLeaf(tree = tinyTree, node = c(15, 13))


ggtree(NT2, ladderize = FALSE) +
    geom_text2(aes(label = label), color = "darkorange",
               hjust = -0.1, vjust = -0.7) +
    geom_point2()

}
