% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/combine.R
\name{rbind,TreeSummarizedExperiment-method}
\alias{rbind,TreeSummarizedExperiment-method}
\alias{cbind,TreeSummarizedExperiment-method}
\alias{TreeSummarizedExperiment-combine}
\title{Combine TSEs by rows or columns}
\usage{
\S4method{rbind}{TreeSummarizedExperiment}(..., deparse.level = 1)

\S4method{cbind}{TreeSummarizedExperiment}(..., deparse.level = 1)
}
\arguments{
\item{...}{One or more \code{TreeSummarizedExperiment} objects.}

\item{deparse.level}{See \code{\link[base]{cbind}}}
}
\value{
A TreeSummarizedExperiment object
}
\description{
\code{rbind} and \code{cbind} take one or more
\code{TreeSummarizedExperiment} objects and combine them by columns or rows,
respectively.
}
\examples{

# rbind works : 
# a) TSE without rowTree and without colTree
# b) TSE with rowTree but without colTree
# c) TSE without rowTree but with colTree
# d) TSE with rowTree & colTree

set.seed(1)
# a) 
(tse_a <- makeTSE(include.colTree = FALSE))
(tse_b <- makeTSE(include.colTree = FALSE))

# b) 
(tse_c <- makeTSE(include.rowTree = FALSE))
(tse_d <- makeTSE(include.rowTree = FALSE))

rbind(tse_a, tse_b)
cbind(tse_c, tse_d)
}
\author{
Ruizhu Huang
}
