% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrajectoryGeometry.R
\name{testPathForDirectionality}
\alias{testPathForDirectionality}
\title{Test a path for directionality}
\usage{
testPathForDirectionality(
  path,
  from = 1,
  to = nrow(path),
  d = ncol(path),
  randomizationParams,
  statistic,
  N
)
}
\arguments{
\item{path}{- An n x m matrix representing a series of n points in
dimension m.}

\item{from}{- The starting place along the path which will be
treated as the center of the sphere.  This defaults to 1.}

\item{to}{- The end point of the path.  This defaults to
nrow(path).}

\item{d}{- The dimension under consideration.  This defaults to
ncol(path)}

\item{randomizationParams}{- A character vector which is used to
control the production of randomized paths for comparison.}

\item{statistic}{- Allowable values are 'median', 'mean' or 'max'}

\item{N}{- The number of random paths to generated for statistical
comparison to the given path.}
}
\value{
This returns a list giving whose entries are:
  pValue - the p-value for the path and statistic in question;
  sphericalData - a list containing the projections of the path to
    the sphere, the center of that sphere and the statistic for
    distance to that center;
  randomDistances - the corresponding distances for randomly chosen;
    paths;
  randomizationParams - the choice of randomization parameters
}
\description{
This is the core function of this package.  It takes a path, and a
choice of statistical measure and computes a statistical significance
for the directionality of that path.
}
\examples{
randomizationParams = c('byPermutation','permuteWithinColumns')
p = testPathForDirectionality(path=straight_path,
                              randomizationParams=randomizationParams,
                              statistic='median',N=100)
q = testPathForDirectionality(path=crooked_path,from=6,
                              randomizationParams=randomizationParams,
                              statistic='median',N=100)
}
