% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrajectoryGeometry.R
\name{findSphereClusterCenter}
\alias{findSphereClusterCenter}
\title{Find a center for points on the unit sphere}
\usage{
findSphereClusterCenter(points, statistic, normalize = FALSE)
}
\arguments{
\item{points}{- A set of n points on the (d-1) sphere given as an n
x d matrix.}

\item{statistic}{- The statistic to be minimized.  Allowable values
are 'median','mean' or 'max'.}

\item{normalize}{- If this is set to TRUE, the function will start
by normalizing the input points.}
}
\value{
This returns a point in dimension d given as a vector.
}
\description{
This function takes a set of points on the d-1 sphere
in d-space and finds a center for these.  Depending on
choice of statistic, this center is a point on the
sphere which minimizes either the median distance, the
mean distance or the maximum distance of the center to
the given points. "Distance" here is taken to mean
angle between the points, i.e., arccos of their dot
product.
}
\examples{
projection = projectPathToSphere(straight_path)
center = findSphereClusterCenter(projection,'mean')
}
