% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeSensitivityProfiles.R
\name{summarizeSensitivityProfiles}
\alias{summarizeSensitivityProfiles}
\title{Takes the sensitivity data from a ToxicoSet, and summarises them into a
drug vs cell line table}
\usage{
summarizeSensitivityProfiles(
  tSet,
  duration = NULL,
  cell_lines = NULL,
  drugs = NULL,
  sensitivity.measure = "auc_recomputed",
  summary.stat = c("mean", "median", "first", "last", "max", "min"),
  fill.missing = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{tSet}{\code{ToxicoSet} The ToxicoSet from which to extract the data}

\item{duration}{\code{numeric} The duration at which to summarize
the drug-cell combo. This is a required parameter.}

\item{cell_lines}{\code{character} The cell lines to be summarized.
If any cell lines has no data, it will be filled with missing values}

\item{drugs}{\code{character} The drugs to be summarized.
If any drugs has no data, it will be filled with
missing values. Defaults to include all drugs in the given tSet.}

\item{sensitivity.measure}{\code{character} which sensitivity sensitivity.measure to use? Use the
sensitivityMeasures function to find out what measures are available for each TSet.}

\item{summary.stat}{\code{character} which summary method to use if there are repeated
cell line-drug experiments? Choices are "mean", "median", "first", "last", "max", or "min"}

\item{fill.missing}{\code{boolean} should the missing cell lines not in the
molecular data object be filled in with missing values?}

\item{verbose}{Should the function print progress messages?}
}
\value{
\code{matrix} A matrix with drugs going down the rows, cell lines across
the columns, with the selected sensitivity statistic for each pair.
}
\description{
This function creates a table with drug as rows and cell lines as columns,
summarising the drug senstitivity data of a ToxicoSet into drug-cell line
pairs for a specified experiment duration.
}
\examples{
data(TGGATESsmall)
TGGATESauc <- summarizeSensitivityProfiles(TGGATESsmall, sensitivity.measure='auc_recomputed')

}
